/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import org.miaixz.bus.core.center.regex.Pattern;
import org.miaixz.bus.core.io.buffer.FastByteBuffer;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ByteKit {
    public static final ByteOrder DEFAULT_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final ByteOrder CPU_ENDIAN = "little".equals(System.getProperty("sun.cpu.endian")) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;

    public static byte[] toBytes(CharSequence text) {
        return ByteKit.toBytes(text, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static byte[] toBytes(CharSequence text, Charset charset) {
        if (text == null) {
            return null;
        }
        if (null == charset) {
            return text.toString().getBytes();
        }
        return text.toString().getBytes(charset);
    }

    public static byte toByte(int intValue) {
        return (byte)intValue;
    }

    public static byte[] toBytes(short shortValue) {
        return ByteKit.toBytes(shortValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(short shortValue, ByteOrder byteOrder) {
        byte[] b = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            b[0] = (byte)(shortValue & 0xFF);
            b[1] = (byte)(shortValue >> 8 & 0xFF);
        } else {
            b[1] = (byte)(shortValue & 0xFF);
            b[0] = (byte)(shortValue >> 8 & 0xFF);
        }
        return b;
    }

    public static byte[] toBytes(char data) {
        byte[] bytes = new byte[]{(byte)data, (byte)(data >> 8)};
        return bytes;
    }

    public static byte[] toBytes(char[] data) {
        CharBuffer cb = CharBuffer.allocate(data.length);
        cb.put(data);
        cb.flip();
        ByteBuffer bb = org.miaixz.bus.core.lang.Charset.UTF_8.encode(cb);
        return bb.array();
    }

    public static byte[] toBytes(int intValue) {
        return ByteKit.toBytes(intValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(int intValue, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return new byte[]{(byte)(intValue & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 24 & 0xFF)};
        }
        return new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)};
    }

    public static byte[] toBytes(long longValue) {
        return ByteKit.toBytes(longValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(long longValue, ByteOrder byteOrder) {
        byte[] result = new byte[8];
        return ByteKit.fill(longValue, 0, byteOrder, result);
    }

    public static byte[] fill(long longValue, int start, ByteOrder byteOrder, byte[] bytes) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = start; i < bytes.length; ++i) {
                bytes[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        } else {
            for (int i = bytes.length - 1; i >= start; --i) {
                bytes[i] = (byte)(longValue & 0xFFL);
                longValue >>= 8;
            }
        }
        return bytes;
    }

    public static byte[] toBytes(float floatValue) {
        return ByteKit.toBytes(floatValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(float floatValue, ByteOrder byteOrder) {
        return ByteKit.toBytes(Float.floatToIntBits(floatValue), byteOrder);
    }

    public static byte[] toBytes(double doubleValue) {
        return ByteKit.toBytes(doubleValue, DEFAULT_ORDER);
    }

    public static byte[] toBytes(double doubleValue, ByteOrder byteOrder) {
        return ByteKit.toBytes(Double.doubleToLongBits(doubleValue), byteOrder);
    }

    public static byte[] toBytes(Number number) {
        return ByteKit.toBytes(number, DEFAULT_ORDER);
    }

    public static byte[] toBytes(Number number, ByteOrder byteOrder) {
        if (number instanceof Byte) {
            return new byte[]{number.byteValue()};
        }
        if (number instanceof Double) {
            return ByteKit.toBytes(number.doubleValue(), byteOrder);
        }
        if (number instanceof Long) {
            return ByteKit.toBytes(number.longValue(), byteOrder);
        }
        if (number instanceof Integer) {
            return ByteKit.toBytes(number.intValue(), byteOrder);
        }
        if (number instanceof Short) {
            return ByteKit.toBytes(number.shortValue(), byteOrder);
        }
        if (number instanceof Float) {
            return ByteKit.toBytes(number.floatValue(), byteOrder);
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).toByteArray();
        }
        return ByteKit.toBytes(number.doubleValue(), byteOrder);
    }

    public static short toShort(byte[] bytes) {
        return ByteKit.toShort(bytes, DEFAULT_ORDER);
    }

    public static short toShort(byte[] bytes, ByteOrder byteOrder) {
        return ByteKit.toShort(bytes, 0, byteOrder);
    }

    public static short toShort(byte[] bytes, int start, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(bytes[start] & 0xFF | (bytes[start + 1] & 0xFF) << 8);
        }
        return (short)(bytes[start + 1] & 0xFF | (bytes[start] & 0xFF) << 8);
    }

    public static int toInt(byte[] bytes) {
        return ByteKit.toInt(bytes, DEFAULT_ORDER);
    }

    public static int toInt(byte[] bytes, ByteOrder byteOrder) {
        return ByteKit.toInt(bytes, 0, byteOrder);
    }

    public static int toInt(byte[] bytes, int start, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return bytes[start] & 0xFF | (bytes[1 + start] & 0xFF) << 8 | (bytes[2 + start] & 0xFF) << 16 | (bytes[3 + start] & 0xFF) << 24;
        }
        return bytes[3 + start] & 0xFF | (bytes[2 + start] & 0xFF) << 8 | (bytes[1 + start] & 0xFF) << 16 | (bytes[start] & 0xFF) << 24;
    }

    public static int toUnsignedInt(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static long toLong(byte[] bytes) {
        return ByteKit.toLong(bytes, DEFAULT_ORDER);
    }

    public static long toLong(byte[] bytes, ByteOrder byteOrder) {
        return ByteKit.toLong(bytes, 0, byteOrder);
    }

    public static long toLong(byte[] bytes, int start, ByteOrder byteOrder) {
        long values = 0L;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 7; i >= 0; --i) {
                values <<= 8;
                values |= (long)bytes[i + start] & 0xFFL;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                values <<= 8;
                values |= (long)bytes[i + start] & 0xFFL;
            }
        }
        return values;
    }

    public static float toFloat(byte[] bytes) {
        return ByteKit.toFloat(bytes, DEFAULT_ORDER);
    }

    public static float toFloat(byte[] bytes, ByteOrder byteOrder) {
        return Float.intBitsToFloat(ByteKit.toInt(bytes, byteOrder));
    }

    public static double toDouble(byte[] bytes) {
        return ByteKit.toDouble(bytes, DEFAULT_ORDER);
    }

    public static double toDouble(byte[] bytes, ByteOrder byteOrder) {
        return Double.longBitsToDouble(ByteKit.toLong(bytes, byteOrder));
    }

    public static <T extends Number> T toNumber(byte[] bytes, Class<T> targetClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Number number;
        if (Byte.class == targetClass) {
            number = bytes[0];
        } else if (Short.class == targetClass) {
            number = ByteKit.toShort(bytes, byteOrder);
        } else if (Integer.class == targetClass) {
            number = ByteKit.toInt(bytes, byteOrder);
        } else if (AtomicInteger.class == targetClass) {
            number = new AtomicInteger(ByteKit.toInt(bytes, byteOrder));
        } else if (Long.class == targetClass) {
            number = ByteKit.toLong(bytes, byteOrder);
        } else if (AtomicLong.class == targetClass) {
            number = new AtomicLong(ByteKit.toLong(bytes, byteOrder));
        } else if (LongAdder.class == targetClass) {
            LongAdder longValue = new LongAdder();
            longValue.add(ByteKit.toLong(bytes, byteOrder));
            number = longValue;
        } else if (Float.class == targetClass) {
            number = Float.valueOf(ByteKit.toFloat(bytes, byteOrder));
        } else if (Double.class == targetClass) {
            number = ByteKit.toDouble(bytes, byteOrder);
        } else if (DoubleAdder.class == targetClass) {
            DoubleAdder doubleAdder = new DoubleAdder();
            doubleAdder.add(ByteKit.toDouble(bytes, byteOrder));
            number = doubleAdder;
        } else if (BigDecimal.class == targetClass) {
            number = MathKit.toBigDecimal(ByteKit.toDouble(bytes, byteOrder));
        } else if (BigInteger.class == targetClass) {
            number = BigInteger.valueOf(ByteKit.toLong(bytes, byteOrder));
        } else if (Number.class == targetClass) {
            number = ByteKit.toDouble(bytes, byteOrder);
        } else {
            throw new IllegalArgumentException("Unsupported Number type: " + targetClass.getName());
        }
        return (T)number;
    }

    public static byte[] toUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] toUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] mag = buf;
        if (off != 0 || length != buf.length) {
            mag = new byte[length];
            System.arraycopy(buf, off, mag, 0, length);
        }
        return new BigInteger(1, mag);
    }

    public static byte[] concat(byte[] ... byteArrays) {
        int totalLength = 0;
        for (byte[] byteArray : byteArrays) {
            totalLength += byteArray.length;
        }
        FastByteBuffer buffer = new FastByteBuffer(totalLength);
        for (byte[] byteArray : byteArrays) {
            buffer.append(byteArray);
        }
        return buffer.toArrayZeroCopyIfPossible();
    }

    public static int bitCount(byte[] buf) {
        int sum = 0;
        for (byte b : buf) {
            sum += Integer.bitCount(b & 0xFF);
        }
        return sum;
    }

    public static List<Integer> toUnsignedBitIndex(byte[] bytes) {
        LinkedList<Integer> idxList = new LinkedList<Integer>();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(StringKit.padPre((CharSequence)Integer.toBinaryString(b & 0xFF), 8, "0"));
        }
        String bitStr = sb.toString();
        for (int i = 0; i < bitStr.length(); ++i) {
            if (bitStr.charAt(i) != '1') continue;
            idxList.add(i);
        }
        return idxList;
    }

    public static int bytesToInt(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToIntBE(data, off) : ByteKit.bytesToIntLE(data, off);
    }

    public static int bytesToIntBE(byte[] data, int off) {
        return (data[off] << 24) + ((data[off + 1] & 0xFF) << 16) + ((data[off + 2] & 0xFF) << 8) + (data[off + 3] & 0xFF);
    }

    public static int bytesToIntLE(byte[] data, int off) {
        return (data[off + 3] << 24) + ((data[off + 2] & 0xFF) << 16) + ((data[off + 1] & 0xFF) << 8) + (data[off] & 0xFF);
    }

    public static int bytesToShort(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToShortBE(data, off) : ByteKit.bytesToShortLE(data, off);
    }

    public static void bytesToShort(byte[] data, short[] s, int off, int len, boolean bigEndian) {
        if (bigEndian) {
            ByteKit.bytesToShortsBE(data, s, off, len);
        } else {
            ByteKit.bytesToShortLE(data, s, off, len);
        }
    }

    public static int bytesToShortBE(byte[] data, int off) {
        return (data[off] << 8) + (data[off + 1] & 0xFF);
    }

    public static int bytesToShortLE(byte[] data, int off) {
        return (data[off + 1] << 8) + (data[off] & 0xFF);
    }

    public static void bytesToShortsBE(byte[] data, short[] s, int off, int len) {
        int boff = 0;
        for (int j = 0; j < len; ++j) {
            byte b0 = data[boff];
            int b1 = data[boff + 1] & 0xFF;
            s[off + j] = (short)(b0 << 8 | b1);
            boff += 2;
        }
    }

    public static void bytesToShortLE(byte[] data, short[] s, int off, int len) {
        int boff = 0;
        for (int j = 0; j < len; ++j) {
            byte b0 = data[boff + 1];
            int b1 = data[boff] & 0xFF;
            s[off + j] = (short)(b0 << 8 | b1);
            boff += 2;
        }
    }

    public static int bytesToUShort(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToUShortBE(data, off) : ByteKit.bytesToUShortLE(data, off);
    }

    public static int bytesToUShortBE(byte[] data, int off) {
        return ((data[off] & 0xFF) << 8) + (data[off + 1] & 0xFF);
    }

    public static int bytesToUShortLE(byte[] data, int off) {
        return ((data[off + 1] & 0xFF) << 8) + (data[off] & 0xFF);
    }

    public static float bytesToFloat(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToFloatBE(data, off) : ByteKit.bytesToFloatLE(data, off);
    }

    public static float bytesToFloatBE(byte[] data, int off) {
        return Float.intBitsToFloat(ByteKit.bytesToIntBE(data, off));
    }

    public static float bytesToFloatLE(byte[] data, int off) {
        return Float.intBitsToFloat(ByteKit.bytesToIntLE(data, off));
    }

    public static long bytesToLong(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToLongBE(data, off) : ByteKit.bytesToLongLE(data, off);
    }

    public static long bytesToLongBE(byte[] data, int off) {
        return ((long)data[off] << 56) + ((long)(data[off + 1] & 0xFF) << 48) + ((long)(data[off + 2] & 0xFF) << 40) + ((long)(data[off + 3] & 0xFF) << 64) + ((long)(data[off + 4] & 0xFF) << 24) + (long)((data[off + 5] & 0xFF) << 16) + (long)((data[off + 6] & 0xFF) << 8) + (long)(data[off + 7] & 0xFF);
    }

    public static long bytesToLongLE(byte[] data, int off) {
        return ((long)data[off + 7] << 56) + ((long)(data[off + 6] & 0xFF) << 48) + ((long)(data[off + 5] & 0xFF) << 40) + ((long)(data[off + 4] & 0xFF) << 64) + ((long)(data[off + 3] & 0xFF) << 24) + (long)((data[off + 2] & 0xFF) << 16) + (long)((data[off + 1] & 0xFF) << 8) + (long)(data[off] & 0xFF);
    }

    public static double bytesToDouble(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToDoubleBE(data, off) : ByteKit.bytesToDoubleLE(data, off);
    }

    public static double bytesToDoubleBE(byte[] data, int off) {
        return Double.longBitsToDouble(ByteKit.bytesToLongBE(data, off));
    }

    public static double bytesToDoubleLE(byte[] data, int off) {
        return Double.longBitsToDouble(ByteKit.bytesToLongLE(data, off));
    }

    public static int bytesToVR(byte[] data, int off) {
        return ByteKit.bytesToUShortBE(data, off);
    }

    public static int bytesToTag(byte[] data, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.bytesToTagBE(data, off) : ByteKit.bytesToTagLE(data, off);
    }

    public static int bytesToTagBE(byte[] data, int off) {
        return ByteKit.bytesToIntBE(data, off);
    }

    public static int bytesToTagLE(byte[] data, int off) {
        return (data[off + 1] << 24) + ((data[off] & 0xFF) << 16) + ((data[off + 3] & 0xFF) << 8) + (data[off + 2] & 0xFF);
    }

    public static byte[] intToBytes(int data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.intToBytesBE(data, bytes, off) : ByteKit.intToBytesLE(data, bytes, off);
    }

    public static byte[] intToBytesBE(int data, byte[] bytes, int off) {
        bytes[off] = (byte)(data >> 24);
        bytes[off + 1] = (byte)(data >> 16);
        bytes[off + 2] = (byte)(data >> 8);
        bytes[off + 3] = (byte)data;
        return bytes;
    }

    public static byte[] intToBytesLE(int data, byte[] bytes, int off) {
        bytes[off + 3] = (byte)(data >> 24);
        bytes[off + 2] = (byte)(data >> 16);
        bytes[off + 1] = (byte)(data >> 8);
        bytes[off] = (byte)data;
        return bytes;
    }

    public static byte[] shortToBytes(int data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.shortToBytesBE(data, bytes, off) : ByteKit.shortToBytesLE(data, bytes, off);
    }

    public static byte[] shortToBytesBE(int data, byte[] bytes, int off) {
        bytes[off] = (byte)(data >> 8);
        bytes[off + 1] = (byte)data;
        return bytes;
    }

    public static byte[] shortToBytesLE(int data, byte[] bytes, int off) {
        bytes[off + 1] = (byte)(data >> 8);
        bytes[off] = (byte)data;
        return bytes;
    }

    public static byte[] longToBytes(long data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.longToBytesBE(data, bytes, off) : ByteKit.longToBytesLE(data, bytes, off);
    }

    public static byte[] longToBytesBE(long data, byte[] bytes, int off) {
        bytes[off] = (byte)(data >> 56);
        bytes[off + 1] = (byte)(data >> 48);
        bytes[off + 2] = (byte)(data >> 40);
        bytes[off + 3] = (byte)(data >> 32);
        bytes[off + 4] = (byte)(data >> 24);
        bytes[off + 5] = (byte)(data >> 16);
        bytes[off + 6] = (byte)(data >> 8);
        bytes[off + 7] = (byte)data;
        return bytes;
    }

    public static byte[] longToBytesLE(long data, byte[] bytes, int off) {
        bytes[off + 7] = (byte)(data >> 56);
        bytes[off + 6] = (byte)(data >> 48);
        bytes[off + 5] = (byte)(data >> 40);
        bytes[off + 4] = (byte)(data >> 32);
        bytes[off + 3] = (byte)(data >> 24);
        bytes[off + 2] = (byte)(data >> 16);
        bytes[off + 1] = (byte)(data >> 8);
        bytes[off] = (byte)data;
        return bytes;
    }

    public static byte[] floatToBytes(float data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.floatToBytesBE(data, bytes, off) : ByteKit.floatToBytesLE(data, bytes, off);
    }

    public static byte[] floatToBytesBE(float data, byte[] bytes, int off) {
        return ByteKit.intToBytesBE(Float.floatToIntBits(data), bytes, off);
    }

    public static byte[] floatToBytesLE(float data, byte[] bytes, int off) {
        return ByteKit.intToBytesLE(Float.floatToIntBits(data), bytes, off);
    }

    public static byte[] doubleToBytes(double data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.doubleToBytesBE(data, bytes, off) : ByteKit.doubleToBytesLE(data, bytes, off);
    }

    public static byte[] doubleToBytesBE(double data, byte[] bytes, int off) {
        return ByteKit.longToBytesBE(Double.doubleToLongBits(data), bytes, off);
    }

    public static byte[] doubleToBytesLE(double data, byte[] bytes, int off) {
        return ByteKit.longToBytesLE(Double.doubleToLongBits(data), bytes, off);
    }

    public static byte[] tagToBytes(int data, byte[] bytes, int off, boolean bigEndian) {
        return bigEndian ? ByteKit.tagToBytesBE(data, bytes, off) : ByteKit.tagToBytesLE(data, bytes, off);
    }

    public static byte[] tagToBytesBE(int data, byte[] bytes, int off) {
        return ByteKit.intToBytesBE(data, bytes, off);
    }

    public static byte[] tagToBytesLE(int data, byte[] bytes, int off) {
        bytes[off + 1] = (byte)(data >> 24);
        bytes[off] = (byte)(data >> 16);
        bytes[off + 3] = (byte)(data >> 8);
        bytes[off + 2] = (byte)data;
        return bytes;
    }

    public static byte[] swapInts(byte[] data, int off, int len) {
        ByteKit.checkLength(len, 4);
        int n = off + len;
        for (int i = off; i < n; i += 4) {
            ByteKit.swap(data, i, i + 3);
            ByteKit.swap(data, i + 1, i + 2);
        }
        return data;
    }

    public static byte[] swapLongs(byte[] data, int off, int len) {
        ByteKit.checkLength(len, 8);
        int n = off + len;
        for (int i = off; i < n; i += 8) {
            ByteKit.swap(data, i, i + 7);
            ByteKit.swap(data, i + 1, i + 6);
            ByteKit.swap(data, i + 2, i + 5);
            ByteKit.swap(data, i + 3, i + 4);
        }
        return data;
    }

    public static byte[][] swapShorts(byte[][] data) {
        int carry = 0;
        for (int i = 0; i < data.length; ++i) {
            byte[] b = data[i];
            if (carry != 0) {
                ByteKit.swapLastFirst(data[i - 1], b);
            }
            int len = b.length - carry;
            ByteKit.swapShorts(b, carry, len & 0xFFFFFFFE);
            carry = len & 1;
        }
        return data;
    }

    public static byte[] swapShorts(byte[] data, int off, int len) {
        ByteKit.checkLength(len, 2);
        int n = off + len;
        for (int i = off; i < n; i += 2) {
            ByteKit.swap(data, i, i + 1);
        }
        return data;
    }

    public static int indexOf(byte[] data, byte target, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (data[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int countOf(byte[] data, byte target) {
        int count = 0;
        for (byte b : data) {
            if (b != target) continue;
            ++count;
        }
        return count;
    }

    public static String bcd(byte[] data, int from, int to) {
        char[] chars = new char[2 * (to - from)];
        for (int i = from; i < to; ++i) {
            int b = ByteKit.unsigned(data[i]);
            chars[2 * (i - from)] = (char)((b >> 4) + 48);
            chars[2 * (i - from) + 1] = (char)((b & 0xF) + 48);
        }
        return new String(chars);
    }

    public static int unsigned(byte data) {
        if (data >= 0) {
            return data;
        }
        return 512 + data;
    }

    public static int xor(byte[] data) {
        int temp = 0;
        if (null != data) {
            for (int i = 0; i < data.length; ++i) {
                temp ^= data[i];
            }
        }
        return temp;
    }

    public static byte[] concat(byte[] buf1, byte[] buf2) {
        byte[] buffer = new byte[buf1.length + buf2.length];
        int offset = 0;
        System.arraycopy(buf1, 0, buffer, offset, buf1.length);
        System.arraycopy(buf2, 0, buffer, offset += buf1.length, buf2.length);
        return buffer;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(Character.forDigit((b & 0xF0) >>> 4, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString().toUpperCase(Locale.ROOT);
    }

    public static byte[] hexStringToByteArray(String digits) {
        int len = digits.length();
        if (!Pattern.VALID_HEX_PATTERN.matcher(digits).matches() || (len & 1) != 0) {
            return new byte[0];
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)(Character.digit(digits.charAt(i), 16) << 4 | Character.digit(digits.charAt(i + 1), 16));
        }
        return data;
    }

    private static void checkLength(int len, int numBytes) {
        if (len < 0 || len % numBytes != 0) {
            throw new IllegalArgumentException("length: " + len);
        }
    }

    private static void swap(byte[] data, int a, int b) {
        byte t = data[a];
        data[a] = data[b];
        data[b] = t;
    }

    private static void swapLastFirst(byte[] b1, byte[] b2) {
        int last = b1.length - 1;
        byte t = b2[0];
        b2[0] = b1[last];
        b1[last] = t;
    }
}

