/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.ansi.Ansi4BitColor;
import org.miaixz.bus.core.lang.ansi.Ansi4bitMapping;
import org.miaixz.bus.core.lang.ansi.Ansi8BitColor;
import org.miaixz.bus.core.lang.ansi.Ansi8bitMapping;
import org.miaixz.bus.core.lang.ansi.AnsiElement;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ColorKit {
    private static final Map<String, Color> COLOR_MAPPING;
    private static final int RGB_COLOR_BOUND = 256;

    public static String toCssRgb(Color color) {
        return StringKit.builder().append("rgb(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(")").toString();
    }

    public static String toCssRgba(Color color) {
        return StringKit.builder().append("rgba(").append(color.getRed()).append(",").append(color.getGreen()).append(",").append(color.getBlue()).append(",").append((double)color.getAlpha() / 255.0).append(")").toString();
    }

    public static String toHex(Color color) {
        return ColorKit.toHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String toHex(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB must be 0~255!");
        }
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static Color getColor(String colorName) {
        if (StringKit.isBlank(colorName)) {
            return null;
        }
        Color color = COLOR_MAPPING.get(colorName = colorName.toUpperCase());
        if (null != color) {
            return color;
        }
        if (StringKit.startWith((CharSequence)colorName, '#')) {
            return ColorKit.hexToColor(colorName);
        }
        if (StringKit.startWith((CharSequence)colorName, '$')) {
            return ColorKit.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = CharsBacker.split(colorName, ",");
        int size = rgb.size();
        if (3 == size) {
            Integer[] rgbIntegers = Convert.toIntArray(rgb);
            return new Color(rgbIntegers[0], rgbIntegers[1], rgbIntegers[2]);
        }
        if (4 == size) {
            Float[] rgbFloats = Convert.toFloatArray(rgb);
            Float a = rgbFloats[3];
            if (a.floatValue() < 1.0f) {
                a = Float.valueOf(a.floatValue() * 255.0f);
            }
            return new Color(rgbFloats[0].floatValue(), rgbFloats[1].floatValue(), rgbFloats[2].floatValue(), a.floatValue());
        }
        return null;
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color getColor(int gray, int[] rgba) {
        int b;
        int g;
        int r;
        int a = 255;
        if (rgba != null && rgba.length >= 3) {
            r = Math.min(rgba[0], 255);
            g = Math.min(rgba[1], 255);
            b = Math.min(rgba[2], 255);
            if (rgba.length > 3) {
                a = Math.min(rgba[3], 255);
            }
        } else {
            g = b = gray >> 8;
            r = b;
        }
        return new Color(r, g, b, a);
    }

    public static Color hexToColor(String hex) {
        return ColorKit.getColor(Integer.parseInt(StringKit.removePrefix(hex, "#"), 16));
    }

    public static Color add(Color color1, Color color2) {
        double r1 = color1.getRed();
        double g1 = color1.getGreen();
        double b1 = color1.getBlue();
        double a1 = color1.getAlpha();
        double r2 = color2.getRed();
        double g2 = color2.getGreen();
        double b2 = color2.getBlue();
        double a2 = color2.getAlpha();
        int r = (int)((r1 * a1 / 255.0 + r2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int g = (int)((g1 * a1 / 255.0 + g2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        int b = (int)((b1 * a1 / 255.0 + b2 * a2 / 255.0) / (a1 / 255.0 + a2 / 255.0));
        return new Color(r, g, b);
    }

    public static Color randomColor() {
        return ColorKit.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomKit.getRandom();
        }
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static AnsiElement toAnsiColor(int rgb, boolean is8Bit, boolean isBackground) {
        return ColorKit.toAnsiColor(ColorKit.getColor(rgb), is8Bit, isBackground);
    }

    public static AnsiElement toAnsiColor(Color color, boolean is8Bit, boolean isBackground) {
        if (is8Bit) {
            Ansi8BitColor ansiElement = (Ansi8BitColor)Ansi8bitMapping.INSTANCE.lookupClosest(color);
            if (isBackground) {
                return ansiElement.asBackground();
            }
            return ansiElement;
        }
        Ansi4BitColor ansiElement = (Ansi4BitColor)Ansi4bitMapping.INSTANCE.lookupClosest(color);
        if (isBackground) {
            return ansiElement.asBackground();
        }
        return ansiElement;
    }

    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        HashMap<CallSite, Long> countMap = new HashMap<CallSite, Long>();
        int width = image.getWidth();
        int height = image.getHeight();
        int minx = image.getMinX();
        int miny = image.getMinY();
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int b;
                int g;
                int pixel = image.getRGB(i, j);
                int r = (pixel & 0xFF0000) >> 16;
                if (ColorKit.matchFilters(r, g = (pixel & 0xFF00) >> 8, b = pixel & 0xFF, rgbFilters)) continue;
                countMap.merge((CallSite)((Object)(r + "-" + g + "-" + b)), 1L, Long::sum);
            }
        }
        String maxColor = null;
        long maxCount = 0L;
        for (Map.Entry entry : countMap.entrySet()) {
            String key = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count <= maxCount) continue;
            maxColor = key;
            maxCount = count;
        }
        String[] splitRgbStr = CharsBacker.splitToArray(maxColor, "-");
        Object rHex = Integer.toHexString(Integer.parseInt(splitRgbStr[0]));
        Object gHex = Integer.toHexString(Integer.parseInt(splitRgbStr[1]));
        Object bHex = Integer.toHexString(Integer.parseInt(splitRgbStr[2]));
        rHex = ((String)rHex).length() == 1 ? "0" + (String)rHex : rHex;
        gHex = ((String)gHex).length() == 1 ? "0" + (String)gHex : gHex;
        bHex = ((String)bHex).length() == 1 ? "0" + (String)bHex : bHex;
        return "#" + (String)rHex + (String)gHex + (String)bHex;
    }

    private static boolean matchFilters(int r, int g, int b, int[] ... rgbFilters) {
        if (ArrayKit.isNotEmpty(rgbFilters)) {
            for (int[] rgbFilter : rgbFilters) {
                if (r != rgbFilter[0] || g != rgbFilter[1] || b != rgbFilter[2]) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Object colorMap = MapKit.builder("BLACK", Color.BLACK).put("WHITE", Color.WHITE).put("LIGHTGRAY", Color.LIGHT_GRAY).put("LIGHT_GRAY", Color.LIGHT_GRAY).put("GRAY", Color.GRAY).put("DARKGRAY", Color.DARK_GRAY).put("DARK_GRAY", Color.DARK_GRAY).put("RED", Color.RED).put("PINK", Color.PINK).put("ORANGE", Color.ORANGE).put("YELLOW", Color.YELLOW).put("GREEN", Color.GREEN).put("MAGENTA", Color.MAGENTA).put("CYAN", Color.CYAN).put("BLUE", Color.BLUE).put("DARKGOLD", ColorKit.hexToColor("#9e7e67")).put("DARK_GOLD", ColorKit.hexToColor("#9e7e67")).put("LIGHTGOLD", ColorKit.hexToColor("#ac9c85")).put("LIGHT_GOLD", ColorKit.hexToColor("#ac9c85")).build();
        COLOR_MAPPING = MapKit.view(colorMap);
    }
}

