/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.miaixz.bus.core.beans.NullWrapper;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.instance.Instances;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.method.MethodInvoker;
import org.miaixz.bus.core.lang.reflect.method.MethodReflect;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StreamKit;
import org.miaixz.bus.core.xyz.StringKit;

public class MethodKit {
    private static final WeakConcurrentMap<Class<?>, MethodReflect> METHODS_CACHE = new WeakConcurrentMap();

    static synchronized void clearCache() {
        METHODS_CACHE.clear();
    }

    public static Method getMethod(Method[] methods, Predicate<Method> predicate) {
        return ArrayKit.get(methods, predicate);
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        return StreamKit.of(MethodKit.getPublicMethods(clazz)).map(Method::getName).collect(Collectors.toSet());
    }

    public static Method getPublicMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StringKit.isBlank(methodName)) {
            return null;
        }
        return MethodKit.getMethod(MethodKit.getPublicMethods(clazz), ignoreCase, methodName, paramTypes);
    }

    public static Method getMethodOfObject(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StringKit.isBlank(methodName)) {
            return null;
        }
        return MethodKit.getMethod(obj.getClass(), methodName, ClassKit.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return MethodKit.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return MethodKit.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StringKit.isBlank(methodName)) {
            return null;
        }
        return MethodKit.getMethod(MethodKit.getMethods(clazz), ignoreCase, methodName, paramTypes);
    }

    public static Method getMethod(Method[] methods, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (ArrayKit.isEmpty(methods) || StringKit.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        if (ArrayKit.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StringKit.equals(methodName, method.getName(), ignoreCase) || !ClassKit.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return MethodKit.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return MethodKit.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StringKit.isBlank(methodName)) {
            return null;
        }
        Method[] methods = MethodKit.getMethods(clazz, method -> StringKit.equals(methodName, method.getName(), ignoreCase) && method.getReturnType().isAssignableFrom(method.getReturnType()));
        return ArrayKit.isEmpty(methods) ? null : methods[0];
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        return StreamKit.of(MethodKit.getMethods(clazz, null)).map(Method::getName).collect(Collectors.toSet());
    }

    public static Method[] getMethods(Class<?> clazz) throws SecurityException {
        return MethodKit.getMethods(clazz, null);
    }

    public static Method[] getMethods(Class<?> clazz, Predicate<Method> predicate) throws SecurityException {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getAllMethods(predicate);
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return MethodKit.getPublicMethods(clazz, null);
    }

    public static Method[] getPublicMethods(Class<?> clazz, Predicate<Method> predicate) {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getPublicMethods(predicate);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) throws SecurityException {
        return MethodKit.getDeclaredMethods(clazz, null);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz, Predicate<Method> predicate) throws SecurityException {
        return METHODS_CACHE.computeIfAbsent(Assert.notNull(clazz), MethodReflect::of).getDeclaredMethods(predicate);
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        return MethodReflect.of(Assert.notNull(beanClass)).getMethodsDirectly(withSupers, withMethodFromObject);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && MethodKit.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && MethodKit.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return MethodKit.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        int parameterCount = method.getParameterCount();
        switch (parameterCount) {
            case 0: {
                return MethodKit.isGetter(method, ignoreCase);
            }
            case 1: {
                return MethodKit.isSetter(method, ignoreCase);
            }
        }
        return false;
    }

    public static boolean isSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (1 != parameterCount) {
            return false;
        }
        String name = method.getName();
        if (name.length() < 4) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        return name.startsWith("set");
    }

    public static boolean isGetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        if (0 != method.getParameterCount()) {
            return false;
        }
        if (Void.class == method.getReturnType()) {
            return false;
        }
        String name = method.getName();
        if (name.length() < 3 || "getClass".equals(name) || "get".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        if (name.startsWith("is")) {
            return BooleanKit.isBoolean(method.getReturnType());
        }
        return name.startsWith("get");
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws InternalException {
        return MethodKit.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws InternalException {
        return MethodInvoker.of(method).setCheckArgs(true).invoke(obj, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws InternalException {
        return MethodInvoker.of(method).invoke(obj, args);
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws InternalException {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = MethodKit.getMethodOfObject(obj, methodName, args);
        if (null == method) {
            throw new InternalException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return MethodKit.invoke(obj, method, args);
    }

    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        return MethodKit.invoke(classNameWithMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        if (StringKit.isBlank(classNameWithMethodName)) {
            throw new InternalException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new InternalException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return MethodKit.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return MethodKit.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class clazz = ClassKit.loadClass(className);
        try {
            Method method = MethodKit.getMethod(clazz, methodName, ClassKit.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StringKit.format("No such method: [{}]", methodName));
            }
            if (ModifierKit.isStatic(method)) {
                return MethodKit.invoke(null, method, args);
            }
            return MethodKit.invoke(isSingleton ? Instances.get(clazz, new Object[0]) : ReflectKit.newInstance(clazz, new Object[0]), method, args);
        }
        catch (Exception e) {
            throw ExceptionKit.wrapRuntime(e);
        }
    }

    public static Object invokeGetter(Object object, String name) {
        for (String method : StringKit.splitToArray(name, ".")) {
            String getterMethodName = "get" + StringKit.capitalize(method);
            object = MethodKit.invoke(object, getterMethodName, new Class[0], new Object[0]);
        }
        return object;
    }

    public static void invokeSetter(Object object, String name, Object value) {
        String[] names = StringKit.splitToArray(name, ".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = "get" + StringKit.capitalize(names[i]);
                object = MethodKit.invoke(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = "set" + StringKit.capitalize(names[i]);
            MethodKit.invoke(object, setterMethodName, value);
        }
    }

    public static Object[] actualArgs(Method method, Object[] args) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (1 == parameterTypes.length && parameterTypes[0].isArray()) {
            return args;
        }
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i = 0; i < actualArgs.length; ++i) {
                if (i >= args.length || null == args[i]) {
                    actualArgs[i] = ClassKit.getDefaultValue(parameterTypes[i]);
                    continue;
                }
                if (args[i] instanceof NullWrapper) {
                    actualArgs[i] = null;
                    continue;
                }
                if (!parameterTypes[i].isAssignableFrom(args[i].getClass())) {
                    Object targetValue = Convert.convert(parameterTypes[i], args[i], args[i]);
                    if (null == targetValue) continue;
                    actualArgs[i] = targetValue;
                    continue;
                }
                actualArgs[i] = args[i];
            }
        }
        return actualArgs;
    }

    public static MethodType methodType(Executable executable) {
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return MethodType.methodType(method.getReturnType(), method.getDeclaringClass(), method.getParameterTypes());
        }
        Constructor constructor = (Constructor)executable;
        return MethodType.methodType(constructor.getDeclaringClass(), constructor.getParameterTypes());
    }

    public static boolean isUserLevelMethod(Method method) {
        Assert.notNull(method, "Method must not be null", new Object[0]);
        return method.isBridge() || !method.isSynthetic() && !MethodKit.isGroovyObjectMethod(method);
    }

    private static boolean isGroovyObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }
}

