/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.miaixz.bus.core.center.object.ObjectValidator;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.SerializeKit;

public class ObjectKit
extends ObjectValidator {
    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        int count = 0;
        if (obj instanceof Iterator || obj instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = obj instanceof Iterator ? (Iterator)obj : ((Iterable)obj).iterator();
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).containsValue(element);
        }
        if (obj instanceof Iterator || obj instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = obj instanceof Iterator ? (Iterator)obj : ((Iterable)obj).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (ArrayKit.isArray(obj)) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T, R> R apply(T source, Function<T, R> handler) {
        return ObjectKit.defaultIfNull(source, handler, null);
    }

    public static <T> void accept(T source, Consumer<T> consumer) {
        if (null != source) {
            consumer.accept(source);
        }
    }

    public static <T> T clone(T obj) {
        T result = ArrayKit.clone(obj);
        if (null != result) {
            return result;
        }
        if (obj instanceof Cloneable) {
            try {
                return MethodKit.invoke(obj, "clone", new Object[0]);
            }
            catch (InternalException e) {
                if (e.getCause() instanceof IllegalAccessException) {
                    return ObjectKit.cloneByStream(obj);
                }
                throw e;
            }
        }
        return ObjectKit.cloneByStream(obj);
    }

    public static <T> T cloneIfPossible(T obj) {
        Object clone = null;
        try {
            clone = ObjectKit.clone(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(clone == null ? obj : clone);
    }

    public static <T> T cloneByStream(T obj) {
        return SerializeKit.clone(obj);
    }

    public static Class<?> getTypeArgument(Object obj) {
        return ObjectKit.getTypeArgument(obj, 0);
    }

    public static Class<?> getTypeArgument(Object obj, int index) {
        return ClassKit.getTypeArgument(obj.getClass(), index);
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (null == o1 || null == o2) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ArrayKit.arrayEquals(o1, o2);
        }
        return false;
    }
}

