/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.desc;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.miaixz.bus.core.bean.desc.BeanDesc;
import org.miaixz.bus.core.bean.desc.PropDesc;
import org.miaixz.bus.core.center.map.CaseInsensitiveMap;
import org.miaixz.bus.core.lang.Assert;

public abstract class AbstractBeanDesc
implements BeanDesc {
    private static final long serialVersionUID = -1L;
    protected final Class<?> beanClass;
    protected final Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    public AbstractBeanDesc(Class<?> beanClass) {
        this.beanClass = Assert.notNull(beanClass);
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }
}

