/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.path.node;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.bean.path.node.Node;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ListNode
implements Node {
    final List<String> names;

    public ListNode(String expression) {
        this.names = CharsBacker.splitTrim(expression, ",");
    }

    @Override
    public Object getValue(Object bean) {
        List<String> names = this.names;
        if (bean instanceof Collection) {
            return CollKit.getAny((Collection)bean, Convert.convert(int[].class, names));
        }
        if (ArrayKit.isArray(bean)) {
            return ArrayKit.getAny(bean, Convert.convert(int[].class, names));
        }
        String[] unWrappedNames = this.getUnWrappedNames(names);
        if (bean instanceof Map) {
            return MapKit.getAny((Map)bean, unWrappedNames);
        }
        Map<String, Object> map = BeanKit.beanToMap(bean, new String[0]);
        return MapKit.getAny(map, unWrappedNames);
    }

    @Override
    public Object setValue(Object bean, Object value) {
        throw new UnsupportedOperationException("Can not set value to multi names.");
    }

    public String toString() {
        return this.names.toString();
    }

    private String[] getUnWrappedNames(List<String> names) {
        String[] unWrappedNames = new String[names.size()];
        for (int i = 0; i < unWrappedNames.length; ++i) {
            unWrappedNames[i] = StringKit.unWrap(names.get(i), '\'');
        }
        return unWrappedNames;
    }
}

