/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.sixty;

import org.miaixz.bus.core.center.date.culture.Samsara;
import org.miaixz.bus.core.center.date.culture.cn.Direction;
import org.miaixz.bus.core.center.date.culture.cn.Element;
import org.miaixz.bus.core.center.date.culture.cn.Opposite;
import org.miaixz.bus.core.center.date.culture.cn.Terrain;
import org.miaixz.bus.core.center.date.culture.cn.minor.PengZuHeavenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.EarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.star.ten.TenStar;

public class HeavenStem
extends Samsara {
    public static final String[] NAMES = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};

    public HeavenStem(int index) {
        super(NAMES, index);
    }

    public HeavenStem(String name) {
        super(NAMES, name);
    }

    public static HeavenStem fromIndex(int index) {
        return new HeavenStem(index);
    }

    public static HeavenStem fromName(String name) {
        return new HeavenStem(name);
    }

    @Override
    public HeavenStem next(int n) {
        return HeavenStem.fromIndex(this.nextIndex(n));
    }

    public Element getElement() {
        return Element.fromIndex(this.index / 2);
    }

    public Opposite getOpposite() {
        return this.index % 2 == 0 ? Opposite.YANG : Opposite.YIN;
    }

    public TenStar getTenStar(HeavenStem target) {
        if (null == target) {
            return null;
        }
        Element host = this.getElement();
        Element guest = target.getElement();
        int index = 0;
        if (host.getReinforce().equals(guest)) {
            index = 1;
        } else if (host.getRestrain().equals(guest)) {
            index = 2;
        } else if (host.getRestrained().equals(guest)) {
            index = 3;
        } else if (host.getReinforced().equals(guest)) {
            index = 4;
        }
        return TenStar.fromIndex(index * 2 + (this.getOpposite().equals((Object)target.getOpposite()) ? 0 : 1));
    }

    public Direction getDirection() {
        return Direction.fromIndex((new int[]{2, 8, 4, 6, 0})[this.index / 2]);
    }

    public Direction getJoyDirection() {
        return Direction.fromIndex((new int[]{7, 5, 1, 8, 3})[this.index % 5]);
    }

    public Direction getYangDirection() {
        return Direction.fromIndex((new int[]{1, 1, 6, 5, 7, 0, 8, 7, 2, 3})[this.index]);
    }

    public Direction getYinDirection() {
        return Direction.fromIndex((new int[]{7, 0, 5, 6, 1, 1, 7, 8, 3, 2})[this.index]);
    }

    public Direction getWealthDirection() {
        return Direction.fromIndex((new int[]{7, 1, 0, 2, 8})[this.index / 2]);
    }

    public Direction getMascotDirection() {
        return Direction.fromIndex((new int[]{3, 3, 2, 2, 0, 8, 1, 1, 5, 6})[this.index]);
    }

    public PengZuHeavenStem getPengZuHeavenStem() {
        return PengZuHeavenStem.fromIndex(this.index);
    }

    public Terrain getTerrain(EarthBranch earthBranch) {
        int earthBranchIndex = earthBranch.getIndex();
        return Terrain.fromIndex((new int[]{1, 6, 10, 9, 10, 9, 7, 0, 4, 3})[this.index] + (Opposite.YANG == this.getOpposite() ? earthBranchIndex : -earthBranchIndex));
    }
}

