/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.en;

import java.time.LocalDate;
import java.time.MonthDay;
import java.util.Date;
import org.miaixz.bus.core.center.date.Calendar;
import org.miaixz.bus.core.center.date.culture.en.Month;
import org.miaixz.bus.core.xyz.EnumKit;

public enum Constellation {
    ARIES(0L, "\u767d\u7f8a", MonthDay.of(3, 21), MonthDay.of(4, 19)),
    TAURUS(1L, "\u91d1\u725b", MonthDay.of(4, 20), MonthDay.of(5, 20)),
    GEMINI(2L, "\u53cc\u5b50", MonthDay.of(5, 21), MonthDay.of(6, 21)),
    CANCER(3L, "\u5de8\u87f9", MonthDay.of(6, 22), MonthDay.of(7, 22)),
    LEO(4L, "\u72ee\u5b50", MonthDay.of(7, 23), MonthDay.of(8, 22)),
    VIRGO(5L, "\u5904\u5973", MonthDay.of(8, 23), MonthDay.of(9, 22)),
    LIBRA(6L, "\u5929\u79e4", MonthDay.of(9, 23), MonthDay.of(10, 23)),
    SCORPIO(7L, "\u5929\u874e", MonthDay.of(10, 24), MonthDay.of(11, 22)),
    SAGITTARIUS(8L, "\u5c04\u624b", MonthDay.of(11, 23), MonthDay.of(12, 21)),
    CAPRICORN(9L, "\u6469\u7faf", MonthDay.of(12, 22), MonthDay.of(1, 19)),
    AQUARIUS(10L, "\u6c34\u74f6", MonthDay.of(1, 20), MonthDay.of(2, 18)),
    PISCES(11L, "\u53cc\u9c7c", MonthDay.of(2, 19), MonthDay.of(3, 20));

    private static final Constellation[] ENUMS;
    private final long code;
    private final String name;
    private final MonthDay begin;
    private final MonthDay end;

    private Constellation(long code, String name, MonthDay begin, MonthDay end) {
        this.code = code;
        this.name = name;
        this.begin = begin;
        this.end = end;
    }

    public static Constellation get(int code) {
        if (code < 1 || code > 12) {
            throw new IllegalArgumentException();
        }
        return ENUMS[(code + 2) % 12];
    }

    public static Constellation get(LocalDate date) {
        return Constellation.get(date.getMonthValue(), date.getDayOfMonth());
    }

    public static Constellation get(int month, int day) {
        return Constellation.get(MonthDay.of(month, day));
    }

    public static Constellation get(MonthDay monthDay) {
        int month = monthDay.getMonthValue();
        int day = monthDay.getDayOfMonth();
        Constellation zodiac = ENUMS[month - 1];
        return day <= zodiac.end.getDayOfMonth() ? zodiac : ENUMS[month % 12];
    }

    public static String getName(Date date) {
        return Constellation.getName(Calendar.calendar(date));
    }

    public static String getName(java.util.Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return Constellation.getName(calendar.get(2), calendar.get(5));
    }

    public static String getName(Month month, int day) {
        return Constellation.getName(month.getValue(), day);
    }

    public static String getName(int month, int day) {
        return Constellation.get((int)month, (int)day).name;
    }

    public static String[] get(String fieldName) {
        return (String[])EnumKit.getFieldValues(Constellation.class, fieldName).toArray(String[]::new);
    }

    public String getName(int code) {
        return Constellation.ENUMS[code].name;
    }

    public long getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        ENUMS = Constellation.values();
    }
}

