/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.lunar;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Galaxy;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Direction;
import org.miaixz.bus.core.center.date.culture.cn.JulianDay;
import org.miaixz.bus.core.center.date.culture.cn.fetus.FetusMonth;
import org.miaixz.bus.core.center.date.culture.cn.sixty.EarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.sixty.HeavenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.cn.star.nine.NineStar;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarSeason;
import org.miaixz.bus.core.center.date.culture.lunar.LunarWeek;
import org.miaixz.bus.core.center.date.culture.lunar.LunarYear;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;

public class LunarMonth
extends Loops {
    public static final String[] NAMES = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u814a\u6708"};
    protected LunarYear year;
    protected int month;
    protected boolean leap;
    protected int dayCount;
    protected int indexInYear;
    protected JulianDay firstJulianDay;

    public LunarMonth(int year, int month) {
        LunarYear currentYear = LunarYear.fromYear(year);
        int currentLeapMonth = currentYear.getLeapMonth();
        if (month == 0 || month > 12 || month < -12) {
            throw new IllegalArgumentException(String.format("illegal lunar month: %d", month));
        }
        boolean leap = month < 0;
        int m = Math.abs(month);
        if (leap && m != currentLeapMonth) {
            throw new IllegalArgumentException(String.format("illegal leap month %d in lunar year %d", m, year));
        }
        SolarTerms dongZhi = SolarTerms.fromIndex(year, 0);
        double dongZhiJd = dongZhi.getCursoryJulianDay();
        double w = Galaxy.calcShuo(dongZhiJd);
        if (w > dongZhiJd) {
            w -= 29.53;
        }
        int offset = 2;
        if (year > 8 && year < 24) {
            offset = 1;
        } else if (LunarYear.fromYear(year - 1).getLeapMonth() > 10 && year != 239 && year != 240) {
            offset = 3;
        }
        int index = m - 1;
        if (leap || currentLeapMonth > 0 && m > currentLeapMonth) {
            ++index;
        }
        this.indexInYear = index;
        double firstDay = Galaxy.calcShuo(w += 29.5306 * (double)(offset + index));
        this.firstJulianDay = JulianDay.fromJulianDay(2451545.0 + firstDay);
        this.dayCount = (int)(Galaxy.calcShuo(w + 29.5306) - firstDay);
        this.year = currentYear;
        this.month = m;
        this.leap = leap;
    }

    public static LunarMonth fromYm(int year, int month) {
        return new LunarMonth(year, month);
    }

    public LunarYear getLunarYear() {
        return this.year;
    }

    public int getYear() {
        return this.year.getYear();
    }

    public int getMonth() {
        return this.month;
    }

    public int getMonthWithLeap() {
        return this.leap ? -this.month : this.month;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public int getIndexInYear() {
        return this.indexInYear;
    }

    public LunarSeason getSeason() {
        return LunarSeason.fromIndex(this.month - 1);
    }

    public JulianDay getFirstJulianDay() {
        return this.firstJulianDay;
    }

    public boolean isLeap() {
        return this.leap;
    }

    public int getWeekCount(int start) {
        return (int)Math.ceil((double)(this.indexOf(this.firstJulianDay.getWeek().getIndex() - start, 7) + this.getDayCount()) / 7.0);
    }

    @Override
    public String getName() {
        return (this.leap ? "\u95f0" : "") + NAMES[this.month - 1];
    }

    @Override
    public String toString() {
        return String.valueOf(this.year) + this.getName();
    }

    @Override
    public LunarMonth next(int n) {
        int add;
        if (n == 0) {
            return LunarMonth.fromYm(this.getYear(), this.getMonthWithLeap());
        }
        int m = this.indexInYear + 1 + n;
        LunarYear y = this.year;
        int leapMonth = y.getLeapMonth();
        int monthSize = 12 + (leapMonth > 0 ? 1 : 0);
        boolean forward = n > 0;
        int n2 = add = forward ? 1 : -1;
        while (forward ? m > monthSize : m <= 0) {
            if (forward) {
                m -= monthSize;
            }
            monthSize = 12 + ((leapMonth = (y = y.next(add)).getLeapMonth()) > 0 ? 1 : 0);
            if (forward) continue;
            m += monthSize;
        }
        boolean leap = false;
        if (leapMonth > 0) {
            if (m == leapMonth + 1) {
                leap = true;
            }
            if (m > leapMonth) {
                --m;
            }
        }
        return LunarMonth.fromYm(y.getYear(), leap ? -m : m);
    }

    public List<LunarDay> getDays() {
        int size = this.getDayCount();
        int y = this.getYear();
        int m = this.getMonthWithLeap();
        ArrayList<LunarDay> l = new ArrayList<LunarDay>(size);
        for (int i = 0; i < size; ++i) {
            l.add(LunarDay.fromYmd(y, m, i + 1));
        }
        return l;
    }

    public List<LunarWeek> getWeeks(int start) {
        int size = this.getWeekCount(start);
        int y = this.getYear();
        int m = this.getMonthWithLeap();
        ArrayList<LunarWeek> l = new ArrayList<LunarWeek>(size);
        for (int i = 0; i < size; ++i) {
            l.add(LunarWeek.fromYm(y, m, i, start));
        }
        return l;
    }

    public SixtyCycle getSixtyCycle() {
        return SixtyCycle.fromName(HeavenStem.fromIndex((this.year.getSixtyCycle().getHeavenStem().getIndex() + 1) * 2 + this.indexInYear).getName() + EarthBranch.fromIndex(this.indexInYear + 2).getName());
    }

    public NineStar getNineStar() {
        return NineStar.fromIndex(27 - this.year.getSixtyCycle().getEarthBranch().getIndex() % 3 * 3 - this.getSixtyCycle().getEarthBranch().getIndex());
    }

    public Direction getJupiterDirection() {
        SixtyCycle sixtyCycle = this.getSixtyCycle();
        int n = (new int[]{7, -1, 1, 3})[sixtyCycle.getEarthBranch().next(-2).getIndex() % 4];
        return n == -1 ? sixtyCycle.getHeavenStem().getDirection() : Direction.fromIndex(n);
    }

    public FetusMonth getFetus() {
        return FetusMonth.fromLunarMonth(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LunarMonth)) {
            return false;
        }
        LunarMonth target = (LunarMonth)o;
        return this.getYear() == target.getYear() && this.getMonthWithLeap() == target.getMonthWithLeap();
    }
}

