/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.object;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.miaixz.bus.core.text.CharsValidator;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ObjectValidator {
    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringKit.isEmpty((CharSequence)obj);
        }
        if (obj instanceof Collection) {
            return CollKit.isEmpty((Collection)obj);
        }
        if (obj instanceof Map) {
            return MapKit.isEmpty((Map)obj);
        }
        if (obj instanceof Iterable) {
            return IteratorKit.isEmpty((Iterable)obj);
        }
        if (obj instanceof Iterator) {
            return IteratorKit.isEmpty((Iterator)obj);
        }
        if (ArrayKit.isArray(obj)) {
            return ArrayKit.isEmpty(obj);
        }
        return false;
    }

    public static boolean isNotEmpty(Object obj) {
        return !ObjectValidator.isEmpty(obj);
    }

    public static boolean isBlankIfString(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return CharsValidator.isBlank((CharSequence)obj);
        }
        return false;
    }

    public static boolean isEmptyIfString(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).length();
        }
        return false;
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return ObjectValidator.isNull(object) ? defaultValue : object;
    }

    public static <T> T defaultIfNull(T source, Supplier<? extends T> defaultSupplier) {
        if (ObjectValidator.isNotNull(source)) {
            return source;
        }
        return defaultSupplier.get();
    }

    public static <T, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, R defaultValue) {
        return ObjectValidator.isNull(source) ? defaultValue : handler.apply(source);
    }

    public static <T, R> R defaultIfNull(T source, Function<? super T, ? extends R> handler, Supplier<? extends R> defaultSupplier) {
        if (ObjectValidator.isNotNull(source)) {
            return handler.apply(source);
        }
        return defaultSupplier.get();
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return MathKit.equals((Number)obj1, (Number)obj2);
        }
        if (ArrayKit.isArray(obj1) && ArrayKit.isArray(obj2)) {
            return ArrayKit.equals(obj1, obj2);
        }
        return Objects.equals(obj1, obj2);
    }

    public static boolean notEquals(Object obj1, Object obj2) {
        return !ObjectValidator.equals(obj1, obj2);
    }

    public static boolean isBasicType(Object object) {
        if (null == object) {
            return false;
        }
        return ClassKit.isBasicType(object.getClass());
    }

    public static boolean isValidIfNumber(Object obj) {
        if (obj instanceof Number) {
            return MathKit.isValidNumber((Number)obj);
        }
        return true;
    }
}

