/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.codec.binary.decoder;

import java.util.Arrays;
import org.miaixz.bus.core.codec.Decoder;
import org.miaixz.bus.core.codec.binary.provider.Base58Provider;
import org.miaixz.bus.core.xyz.StringKit;

public class Base58Decoder
implements Decoder<CharSequence, byte[]> {
    public static Base58Decoder DECODER = new Base58Decoder("123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz");
    private final byte[] lookupTable;

    public Base58Decoder(String alphabet) {
        byte[] lookupTable = new byte[123];
        Arrays.fill(lookupTable, (byte)-1);
        int length = alphabet.length();
        for (int i = 0; i < length; ++i) {
            lookupTable[alphabet.charAt((int)i)] = (byte)i;
        }
        this.lookupTable = lookupTable;
    }

    @Override
    public byte[] decode(CharSequence encoded) {
        int zeros;
        if (encoded.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[encoded.length()];
        for (int i = 0; i < encoded.length(); ++i) {
            int digit;
            char c = encoded.charAt(i);
            int n = digit = c < '\u0080' ? this.lookupTable[c] : -1;
            if (digit < 0) {
                throw new IllegalArgumentException(StringKit.format("Invalid char '{}' at [{}]", Character.valueOf(c), i));
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[encoded.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58Provider.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }
}

