/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.miaixz.bus.core.convert.ArrayConverter;
import org.miaixz.bus.core.convert.BeanConverter;
import org.miaixz.bus.core.convert.ClassConverter;
import org.miaixz.bus.core.convert.CollectionConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.convert.DateConverter;
import org.miaixz.bus.core.convert.EntryConverter;
import org.miaixz.bus.core.convert.EnumConverter;
import org.miaixz.bus.core.convert.KotlinBeanConverter;
import org.miaixz.bus.core.convert.MapConverter;
import org.miaixz.bus.core.convert.NumberConverter;
import org.miaixz.bus.core.convert.PrimitiveConverter;
import org.miaixz.bus.core.convert.RecordConverter;
import org.miaixz.bus.core.convert.RegisterConverter;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.KotlinKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.RecordKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class CompositeConverter
extends RegisterConverter {
    private static final long serialVersionUID = -1L;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Object convert(Type type, Object value) throws ConvertException {
        return this.convert(type, value, null);
    }

    @Override
    public <T> T convert(Type type, Object value, T defaultValue) throws ConvertException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws ConvertException {
        Object result;
        Converter converter;
        if (ObjectKit.isNull(value)) {
            return defaultValue;
        }
        if (TypeKit.isUnknown(type)) {
            if (null == defaultValue) {
                return (T)value;
            }
            type = defaultValue.getClass();
        }
        if (value instanceof Optional && ObjectKit.isNull(value = ((Optional)value).get())) {
            return defaultValue;
        }
        if (value instanceof java.util.Optional && ObjectKit.isNull(value = ((java.util.Optional)value).orElse(null))) {
            return defaultValue;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(type, value, defaultValue);
        }
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(type, value, defaultValue);
        }
        Class<?> rowType = TypeKit.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                throw new ConvertException("Can not get class from type: {}", type);
            }
        }
        if (null != (result = this.convertSpecial(type, rowType, value, defaultValue))) {
            return (T)result;
        }
        if (BeanKit.isWritableBean(rowType)) {
            return (T)BeanConverter.INSTANCE.convert(type, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, type.getTypeName());
    }

    private <T> T convertSpecial(Type type, Class<T> rowType, Object value, T defaultValue) {
        if (null == rowType) {
            return null;
        }
        if (Date.class.isAssignableFrom(rowType)) {
            return DateConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (Collection.class.isAssignableFrom(rowType)) {
            return (T)CollectionConverter.INSTANCE.convert(type, value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(rowType)) {
            return (T)MapConverter.INSTANCE.convert(type, value, (Map)defaultValue);
        }
        if (Map.Entry.class.isAssignableFrom(rowType)) {
            return (T)EntryConverter.INSTANCE.convert(type, value);
        }
        if (rowType.isInstance(value)) {
            return (T)value;
        }
        if (rowType.isPrimitive()) {
            return PrimitiveConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (Number.class.isAssignableFrom(rowType)) {
            return NumberConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isEnum()) {
            return EnumConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (rowType.isArray()) {
            return ArrayConverter.INSTANCE.convert(type, value, defaultValue);
        }
        if (RecordKit.isRecord(rowType)) {
            return (T)RecordConverter.INSTANCE.convert(type, value);
        }
        if (KotlinKit.isKotlinClass(rowType)) {
            return (T)KotlinBeanConverter.INSTANCE.convert(type, value);
        }
        if ("java.lang.Class".equals(rowType.getName())) {
            return (T)ClassConverter.INSTANCE.convert(type, value);
        }
        if (ObjectKit.isEmpty(value)) {
            return ReflectKit.newInstanceIfPossible(rowType);
        }
        return null;
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

