/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.StringKit;

public class NumberConverter
extends AbstractConverter {
    public static final NumberConverter INSTANCE = new NumberConverter();
    private static final long serialVersionUID = -1L;

    protected static Number convert(Object value, Class<? extends Number> targetType, Function<Object, String> toStrFunc) {
        if (value instanceof Enum) {
            return NumberConverter.convert(((Enum)value).ordinal(), targetType, toStrFunc);
        }
        if (value instanceof byte[]) {
            return ByteKit.toNumber((byte[])value, targetType, ByteKit.DEFAULT_ORDER);
        }
        if (Byte.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toByteObject((Boolean)value);
            }
            String valueStr = toStrFunc.apply(value);
            try {
                return Byte.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return MathKit.parseNumber(valueStr).byteValue();
            }
        }
        if (Short.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toShortObject((Boolean)value);
            }
            String valueStr = toStrFunc.apply(value);
            try {
                return Short.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return MathKit.parseNumber(valueStr).shortValue();
            }
        }
        if (Integer.class == targetType) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return BooleanKit.toInteger((Boolean)value);
            }
            if (value instanceof Date) {
                return (int)((Date)value).getTime();
            }
            if (value instanceof Calendar) {
                return (int)((Calendar)value).getTimeInMillis();
            }
            if (value instanceof TemporalAccessor) {
                return (int)DateKit.toInstant((TemporalAccessor)value).toEpochMilli();
            }
            String valueStr = toStrFunc.apply(value);
            return MathKit.parseInt(valueStr);
        }
        if (AtomicInteger.class == targetType) {
            Number number = NumberConverter.convert(value, Integer.class, toStrFunc);
            if (null != number) {
                return new AtomicInteger(number.intValue());
            }
        } else {
            if (Long.class == targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                if (value instanceof Boolean) {
                    return BooleanKit.toLongObject((Boolean)value);
                }
                if (value instanceof Date) {
                    return ((Date)value).getTime();
                }
                if (value instanceof Calendar) {
                    return ((Calendar)value).getTimeInMillis();
                }
                if (value instanceof TemporalAccessor) {
                    return DateKit.toInstant((TemporalAccessor)value).toEpochMilli();
                }
                String valueStr = toStrFunc.apply(value);
                return MathKit.parseLong(valueStr);
            }
            if (AtomicLong.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, toStrFunc);
                if (null != number) {
                    return new AtomicLong(number.longValue());
                }
            } else if (LongAdder.class == targetType) {
                Number number = NumberConverter.convert(value, Long.class, toStrFunc);
                if (null != number) {
                    LongAdder longValue = new LongAdder();
                    longValue.add(number.longValue());
                    return longValue;
                }
            } else {
                if (Float.class == targetType) {
                    if (value instanceof Number) {
                        return Float.valueOf(((Number)value).floatValue());
                    }
                    if (value instanceof Boolean) {
                        return BooleanKit.toFloatObject((Boolean)value);
                    }
                    String valueStr = toStrFunc.apply(value);
                    return Float.valueOf(MathKit.parseFloat(valueStr));
                }
                if (Double.class == targetType) {
                    if (value instanceof Number) {
                        return MathKit.toDouble((Number)value);
                    }
                    if (value instanceof Boolean) {
                        return BooleanKit.toDoubleObject((Boolean)value);
                    }
                    String valueStr = toStrFunc.apply(value);
                    return MathKit.parseDouble(valueStr);
                }
                if (DoubleAdder.class == targetType) {
                    Number number = NumberConverter.convert(value, Double.class, toStrFunc);
                    if (null != number) {
                        DoubleAdder doubleAdder = new DoubleAdder();
                        doubleAdder.add(number.doubleValue());
                        return doubleAdder;
                    }
                } else {
                    if (BigDecimal.class == targetType) {
                        return NumberConverter.toBigDecimal(value, toStrFunc);
                    }
                    if (BigInteger.class == targetType) {
                        return NumberConverter.toBigInteger(value, toStrFunc);
                    }
                    if (Number.class == targetType) {
                        if (value instanceof Number) {
                            return (Number)value;
                        }
                        if (value instanceof Boolean) {
                            return BooleanKit.toInteger((Boolean)value);
                        }
                        String valueStr = toStrFunc.apply(value);
                        return MathKit.parseNumber(valueStr);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(StringKit.format("Unsupport Number type: {}", targetType.getName()));
    }

    private static BigDecimal toBigDecimal(Object value, Function<Object, String> toStrFunc) {
        if (value instanceof Number) {
            return MathKit.toBigDecimal((Number)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return MathKit.toBigDecimal(toStrFunc.apply(value));
    }

    private static BigInteger toBigInteger(Object value, Function<Object, String> toStrFunc) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        return MathKit.toBigInteger(toStrFunc.apply(value));
    }

    @Override
    protected Number convertInternal(Class<?> targetClass, Object value) {
        return NumberConverter.convert(value, targetClass, this::convertToString);
    }

    @Override
    protected String convertToString(Object value) {
        char c;
        String result = StringKit.trim(super.convertToString(value));
        if (StringKit.isEmpty(result)) {
            throw new ConvertException("Can not convert empty value to Number!");
        }
        if (result.length() > 1 && ((c = Character.toUpperCase(result.charAt(result.length() - 1))) == 'D' || c == 'L' || c == 'F')) {
            return StringKit.subPre(result, -1);
        }
        return result;
    }
}

