/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.convert.CompositeConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.lang.reflect.TypeReference;
import org.miaixz.bus.core.lang.tuple.Triplet;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class TripleConverter
implements Converter {
    public static final TripleConverter INSTANCE = new TripleConverter();

    private static Triplet<?, ?, ?> mapToTriple(Type leftType, Type middleType, Type rightType, Map map) {
        Object left = map.get("left");
        Object middle = map.get("middle");
        Object right = map.get("right");
        CompositeConverter convert = CompositeConverter.getInstance();
        return Triplet.of(TypeKit.isUnknown(leftType) ? left : convert.convert(leftType, left), TypeKit.isUnknown(middleType) ? middle : convert.convert(middleType, middle), TypeKit.isUnknown(rightType) ? right : convert.convert(rightType, right));
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof TypeReference) {
            targetType = ((TypeReference)targetType).getType();
        }
        Type leftType = TypeKit.getTypeArgument(targetType, 0);
        Type middileType = TypeKit.getTypeArgument(targetType, 1);
        Type rightType = TypeKit.getTypeArgument(targetType, 2);
        return this.convert(leftType, middileType, rightType, value);
    }

    public Triplet<?, ?, ?> convert(Type leftType, Type middleType, Type rightType, Object value) throws ConvertException {
        Map<String, Object> map = null;
        if (BeanKit.isReadableBean(value.getClass())) {
            map = BeanKit.beanToMap(value, new String[0]);
        }
        if (null != map) {
            return TripleConverter.mapToTriple(leftType, middleType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }
}

