/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.miaixz.bus.core.lang.exception.InternalException;

public class InflaterStream
extends InputStream {
    private final InflaterInputStream in;

    public InflaterStream(InputStream wrapped) {
        this(wrapped, 512);
    }

    public InflaterStream(InputStream wrapped, int size) {
        int i2;
        int i1;
        PushbackInputStream pushback = new PushbackInputStream(wrapped, 2);
        try {
            i1 = pushback.read();
            i2 = pushback.read();
            if (i1 == -1 || i2 == -1) {
                throw new InternalException("Unexpected end of stream");
            }
            pushback.unread(i2);
            pushback.unread(i1);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        boolean nowrap = true;
        int b1 = i1 & 0xFF;
        int compressionMethod = b1 & 0xF;
        int compressionInfo = b1 >> 4 & 0xF;
        int b2 = i2 & 0xFF;
        if (compressionMethod == 8 && compressionInfo <= 7 && (b1 << 8 | b2) % 31 == 0) {
            nowrap = false;
        }
        this.in = new InflaterInputStream(pushback, new Inflater(nowrap), size);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

