/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Wrapper;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class FileWrapper
implements Wrapper<File>,
Serializable {
    private static final long serialVersionUID = -1L;
    protected File file;
    protected Charset charset;

    public FileWrapper(File file, Charset charset) {
        this.file = Assert.notNull(file);
        this.charset = ObjectKit.defaultIfNull(charset, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    @Override
    public File getRaw() {
        return this.file;
    }

    public FileWrapper setFile(File file) {
        this.file = file;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public FileWrapper setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public String readableFileSize() {
        return FileKit.readableFileSize(this.file.length());
    }
}

