/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.miaixz.bus.core.io.file.FileWrapper;
import org.miaixz.bus.core.io.file.LineSeparator;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class FileWriter
extends FileWrapper {
    private static final long serialVersionUID = -1L;

    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileWriter(String filePath, Charset charset) {
        this(FileKit.file(filePath), charset);
    }

    public FileWriter(String filePath, String charset) {
        this(FileKit.file(filePath), org.miaixz.bus.core.lang.Charset.charset(charset));
    }

    public FileWriter(File file) {
        this(file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public FileWriter(String filePath) {
        this(filePath, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static FileWriter of(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public static FileWriter of(File file) {
        return new FileWriter(file);
    }

    public File write(String content, boolean isAppend) throws InternalException {
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(isAppend);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(writer);
                throw throwable;
            }
        }
        IoKit.closeQuietly(writer);
        return this.file;
    }

    public File write(String content) throws InternalException {
        return this.write(content, false);
    }

    public File append(String content) throws InternalException {
        return this.write(content, true);
    }

    public <T> File writeLines(Iterable<T> list) throws InternalException {
        return this.writeLines(list, false);
    }

    public <T> File appendLines(Iterable<T> list) throws InternalException {
        return this.writeLines(list, true);
    }

    public <T> File writeLines(Iterable<T> list, boolean isAppend) throws InternalException {
        return this.writeLines(list, null, isAppend);
    }

    public <T> File writeLines(Iterable<T> list, LineSeparator lineSeparator, boolean isAppend) throws InternalException {
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            boolean isFirst = true;
            for (T t : list) {
                if (null == t) continue;
                if (isFirst) {
                    isFirst = false;
                    if (isAppend && FileKit.isNotEmpty(this.file)) {
                        this.printNewLine(writer, lineSeparator);
                    }
                } else {
                    this.printNewLine(writer, lineSeparator);
                }
                writer.print(t);
                writer.flush();
            }
        }
        return this.file;
    }

    public File writeMap(Map<?, ?> map, String kvSeparator, boolean isAppend) throws InternalException {
        return this.writeMap(map, null, kvSeparator, isAppend);
    }

    public File writeMap(Map<?, ?> map, LineSeparator lineSeparator, String kvSeparator, boolean isAppend) throws InternalException {
        if (null == kvSeparator) {
            kvSeparator = " = ";
        }
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (null == entry) continue;
                writer.print(StringKit.format("{}{}{}", entry.getKey(), kvSeparator, entry.getValue()));
                this.printNewLine(writer, lineSeparator);
                writer.flush();
            }
        }
        return this.file;
    }

    public File write(byte[] data, int off, int len) throws InternalException {
        return this.write(data, off, len, false);
    }

    public File append(byte[] data, int off, int len) throws InternalException {
        return this.write(data, off, len, true);
    }

    public File write(byte[] data, int off, int len, boolean isAppend) throws InternalException {
        try (FileOutputStream out = new FileOutputStream(FileKit.touch(this.file), isAppend);){
            out.write(data, off, len);
            out.flush();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return this.file;
    }

    public File writeFromStream(InputStream in) throws InternalException {
        return this.writeFromStream(in, true);
    }

    public File writeFromStream(InputStream in, boolean isCloseIn) throws InternalException {
        OutputStream out = null;
        try {
            out = Files.newOutputStream(FileKit.touch(this.file).toPath(), new OpenOption[0]);
            IoKit.copy(in, out);
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                IoKit.closeQuietly(out);
                if (isCloseIn) {
                    IoKit.closeQuietly(in);
                }
                throw throwable;
            }
        }
        IoKit.closeQuietly(out);
        if (isCloseIn) {
            IoKit.closeQuietly(in);
        }
        return this.file;
    }

    public BufferedOutputStream getOutputStream() throws InternalException {
        try {
            return new BufferedOutputStream(Files.newOutputStream(FileKit.touch(this.file).toPath(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public BufferedWriter getWriter(boolean isAppend) throws InternalException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileKit.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public PrintWriter getPrintWriter(boolean isAppend) throws InternalException {
        return new PrintWriter(this.getWriter(isAppend));
    }

    private void checkFile() throws InternalException {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new InternalException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }

    private void printNewLine(PrintWriter writer, LineSeparator lineSeparator) {
        if (null == lineSeparator) {
            writer.println();
        } else {
            writer.print(lineSeparator.getValue());
        }
    }
}

