/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.StringKit;

public class BytesResource
implements Resource,
Serializable {
    private static final long serialVersionUID = -1L;
    private final byte[] bytes;
    private final String name;

    public BytesResource(byte[] bytes) {
        this(bytes, null);
    }

    public BytesResource(byte[] bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public long size() {
        return this.bytes.length;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public String readString(Charset charset) throws InternalException {
        return StringKit.toString(this.bytes, charset);
    }

    @Override
    public byte[] readBytes() throws InternalException {
        return this.bytes;
    }
}

