/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.UrlKit;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = -1L;
    private final File file;
    private final long lastModified;
    private final String name;

    public FileResource(String path) {
        this(FileKit.file(path));
    }

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, null);
    }

    public FileResource(File file, String fileName) {
        Assert.notNull(file, "File must be not null !", new Object[0]);
        this.file = file;
        this.lastModified = file.lastModified();
        this.name = ObjectKit.defaultIfNull(fileName, file::getName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return UrlKit.getURL(this.file);
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public InputStream getStream() throws InternalException {
        return FileKit.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.file.lastModified();
    }

    public String toString() {
        return this.file.toString();
    }
}

