/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Console;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Keys {
    public static final String OS_NAME = "os.name";
    public static final String OS_ARCH = "os.arch";
    public static final String OS_VERSION = "os.version";
    public static final String USER_NAME = "user.name";
    public static final String USER_HOME = "user.home";
    public static final String USER_DIR = "user.dir";
    public static final String FILE_ENCODING = "file.encoding";
    public static final String USER_LANGUAGE = "user.language";
    public static final String USER_COUNTRY = "user.country";
    public static final String USER_REGION = "user.region";
    public static final String FILE_SEPARATOR = "file.separator";
    public static final String PATH_SEPARATOR = "path.separator";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String JAVA_VERSION = "java.version";
    public static final String JAVA_VENDOR = "java.vendor";
    public static final String JAVA_VENDOR_URL = "java.vendor.url";
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String JAVA_VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String JAVA_VM_SPECIFICATION_NAME = "java.vm.specification.name";
    public static final String JAVA_VM_VERSION = "java.vm.version";
    public static final String JAVA_VM_VENDOR = "java.vm.vendor";
    public static final String JAVA_VM_NAME = "java.vm.name";
    public static final String JAVA_VM_INFO = " java.vm.info";
    public static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    public static final String JAVA_SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String JAVA_SPECIFICATION_NAME = "java.specification.name";
    public static final String JAVA_CLASS_VERSION = "java.class.version";
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final String JAVA_COMPILER = "java.compiler";
    public static final String JAVA_EXT_DIRS = "java.ext.dirs";
    public static final String JAVA_RUNTIME_NAME = " java.runtime.name";
    public static final String JAVA_RUNTIME_VERSION = "java.runtime.version";
    public static final String JAVA_ENDORSED_DIRS = "java.endorsed.dirs";
    public static final String SUN_BOOT_CLASS_PATH = "sun.boot.class.path";
    public static final String SUN_ARCH_DATA_MODEL = "sun.arch.data.model";
    public static final String DATE_LENIENT = "bus.date.lenient";
    public static final int JVM_VERSION = Keys._getJvmVersion();
    public static final boolean IS_JDK8 = 8 == JVM_VERSION;
    public static final boolean IS_AT_LEAST_JDK17 = JVM_VERSION >= 17;
    public static final boolean IS_ANDROID;
    public static final boolean IS_OPENJ9;

    public static String get(String name, String defaultValue) {
        return ObjectKit.defaultIfNull(Keys.get(name), defaultValue);
    }

    public static String get(String key) {
        return Keys.get(key, false);
    }

    public static String getQuietly(String key) {
        return Keys.get(key, true);
    }

    public static String get(String name, boolean quiet) {
        String value;
        block6: {
            block5: {
                value = null;
                try {
                    value = System.getProperty(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block5;
                    Console.error("Caught a SecurityException reading the system property '{}'; the Keys property value will default to null.", name);
                }
            }
            if (null == value) {
                try {
                    value = System.getenv(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block6;
                    Console.error("Caught a SecurityException reading the system env '{}'; the Keys env value will default to null.", name);
                }
            }
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = Keys.get(key);
        if (value == null) {
            return defaultValue;
        }
        return BooleanKit.toBoolean(value);
    }

    public static int getInt(String key, int defaultValue) {
        return Convert.toInt(Keys.get(key), defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        return Convert.toLong(Keys.get(key), defaultValue);
    }

    public static Properties getProps() {
        return System.getProperties();
    }

    public static void set(String key, String value) {
        if (null == value) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    public static String[] getJavaClassPaths() {
        return Keys.get(JAVA_CLASS_PATH).split(Keys.get(PATH_SEPARATOR));
    }

    public static String getUserHomePath() {
        return Keys.get(USER_HOME);
    }

    public static String getTmpDirPath() {
        return Keys.get(JAVA_IO_TMPDIR);
    }

    static String _getJvmName() {
        return Keys.getQuietly(JAVA_VM_NAME);
    }

    public static int _getJvmVersion() {
        int jvmVersion = 8;
        String javaSpecVer = Keys.getQuietly(JAVA_SPECIFICATION_VERSION);
        if (StringKit.isNotBlank(javaSpecVer)) {
            if (javaSpecVer.startsWith("1.")) {
                javaSpecVer = javaSpecVer.substring(2);
            }
            if (javaSpecVer.indexOf(46) == -1) {
                jvmVersion = Integer.parseInt(javaSpecVer);
            }
        }
        return jvmVersion;
    }

    public static Attributes getAttributes(String uri, String ... attrIds) {
        try {
            return Keys.createInitialDirContext(null).getAttributes(uri, attrIds);
        }
        catch (NamingException e) {
            throw new InternalException(e);
        }
    }

    static InitialDirContext createInitialDirContext(Map<String, String> environment) {
        try {
            if (MapKit.isEmpty(environment)) {
                return new InitialDirContext();
            }
            return new InitialDirContext(Convert.convert(Hashtable.class, environment));
        }
        catch (NamingException e) {
            throw new InternalException(e);
        }
    }

    static InitialContext createInitialContext(Map<String, String> environment) {
        try {
            if (MapKit.isEmpty(environment)) {
                return new InitialContext();
            }
            return new InitialContext(Convert.convert(Hashtable.class, environment));
        }
        catch (NamingException e) {
            throw new InternalException(e);
        }
    }

    static {
        String jvmName = Keys._getJvmName();
        IS_ANDROID = jvmName.equals("Dalvik");
        IS_OPENJ9 = jvmName.contains("OpenJ9");
    }
}

