/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.loader;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.loader.LazyLoader;

public class LazyFunLoader<T>
extends LazyLoader<T> {
    private static final long serialVersionUID = -1L;
    private Supplier<T> supplier;

    public LazyFunLoader(Supplier<T> supplier) {
        Assert.notNull(supplier);
        this.supplier = supplier;
    }

    public static <T> LazyFunLoader<T> on(Supplier<T> supplier) {
        Assert.notNull(supplier, "supplier must be not null!", new Object[0]);
        return new LazyFunLoader<T>(supplier);
    }

    @Override
    protected T init() {
        T t = this.supplier.get();
        this.supplier = null;
        return t;
    }

    public boolean isInitialize() {
        return this.supplier == null;
    }

    public void ifInitialized(Consumer<T> consumer) {
        Assert.notNull(consumer);
        if (this.isInitialize()) {
            consumer.accept(this.get());
        }
    }
}

