/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.miaixz.bus.core.lang.annotation.resolve.AnnotatedElements;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.PredicateKit;
import org.miaixz.bus.core.xyz.StringKit;

public class MethodMatcher {
    @SafeVarargs
    public static Predicate<Method> noneMatch(Predicate<Method> ... matchers) {
        return PredicateKit.none(matchers);
    }

    @SafeVarargs
    public static Predicate<Method> anyMatch(Predicate<Method> ... matchers) {
        return PredicateKit.or(matchers);
    }

    @SafeVarargs
    public static Predicate<Method> allMatch(Predicate<Method> ... matchers) {
        return PredicateKit.and(matchers);
    }

    public static Predicate<Method> isPublic() {
        return MethodMatcher.forModifiers(1);
    }

    public static Predicate<Method> isStatic() {
        return MethodMatcher.forModifiers(8);
    }

    public static Predicate<Method> isPublicStatic() {
        return MethodMatcher.forModifiers(1, 8);
    }

    public static Predicate<Method> forModifiers(int ... modifiers) {
        return method -> ModifierKit.hasAllModifier(method.getModifiers(), modifiers);
    }

    public static Predicate<Method> hasDeclaredAnnotation(Class<? extends Annotation> annotationType) {
        return method -> method.isAnnotationPresent(annotationType);
    }

    public static Predicate<Method> hasAnnotation(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElements.isAnnotationPresent(method, annotationType);
    }

    public static Predicate<Method> hasAnnotationOnDeclaringClass(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElements.isAnnotationPresent(method.getDeclaringClass(), annotationType);
    }

    public static Predicate<Method> hasAnnotationOnMethodOrDeclaringClass(Class<? extends Annotation> annotationType) {
        return method -> AnnotatedElements.isAnnotationPresent(method, annotationType) || AnnotatedElements.isAnnotationPresent(method.getDeclaringClass(), annotationType);
    }

    public static Predicate<Method> forGetterMethod(String fieldName, Class<?> fieldType) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldType);
        Predicate<Method> nameMatcher = MethodMatcher.forName(StringKit.upperFirstAndAddPre(fieldName, "get"));
        nameMatcher = nameMatcher.or(MethodMatcher.forName(fieldName));
        if (Objects.equals(Boolean.TYPE, fieldType) || Objects.equals(Boolean.class, fieldType)) {
            nameMatcher = nameMatcher.or(MethodMatcher.forName(StringKit.upperFirstAndAddPre(fieldName, "is")));
        }
        return MethodMatcher.allMatch(nameMatcher, MethodMatcher.forReturnType(fieldType), MethodMatcher.forNoneParameter());
    }

    public static Predicate<Method> forGetterMethod(Field field) {
        Objects.requireNonNull(field);
        return MethodMatcher.forGetterMethod(field.getName(), field.getType());
    }

    public static Predicate<Method> forSetterMethod(String fieldName, Class<?> fieldType) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(fieldType);
        Predicate<Method> nameMatcher = MethodMatcher.forName(StringKit.upperFirstAndAddPre(fieldName, "set")).or(MethodMatcher.forName(fieldName));
        return MethodMatcher.allMatch(nameMatcher, MethodMatcher.forParameterTypes(fieldType));
    }

    public static Predicate<Method> forSetterMethod(Field field) {
        Objects.requireNonNull(field);
        return MethodMatcher.forSetterMethod(field.getName(), field.getType());
    }

    public static Predicate<Method> forNameAndParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcher.allMatch(MethodMatcher.forName(methodName), MethodMatcher.forParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forNameAndStrictParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcher.allMatch(MethodMatcher.forName(methodName), MethodMatcher.forStrictParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forNameIgnoreCaseAndParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcher.allMatch(MethodMatcher.forNameIgnoreCase(methodName), MethodMatcher.forParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forNameIgnoreCaseAndStrictParameterTypes(String methodName, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(parameterTypes);
        return MethodMatcher.allMatch(MethodMatcher.forNameIgnoreCase(methodName), MethodMatcher.forStrictParameterTypes(parameterTypes));
    }

    public static Predicate<Method> forMethodSignature(Method method) {
        Objects.requireNonNull(method);
        return MethodMatcher.forMethodSignature(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static Predicate<Method> forMethodSignature(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Predicate<Method> resultMatcher = Objects.isNull(returnType) ? MethodMatcher.forNoneReturnType() : MethodMatcher.forReturnType(returnType);
        Predicate<Method> parameterMatcher = Objects.isNull(parameterTypes) ? MethodMatcher.forNoneParameter() : MethodMatcher.forParameterTypes(parameterTypes);
        return MethodMatcher.allMatch(MethodMatcher.forName(methodName), resultMatcher, parameterMatcher);
    }

    public static Predicate<Method> forStrictMethodSignature(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        Objects.requireNonNull(methodName);
        Predicate<Method> resultMatcher = Objects.isNull(returnType) ? MethodMatcher.forNoneReturnType() : MethodMatcher.forReturnType(returnType);
        Predicate<Method> parameterMatcher = Objects.isNull(parameterTypes) ? MethodMatcher.forNoneParameter() : MethodMatcher.forStrictParameterTypes(parameterTypes);
        return MethodMatcher.allMatch(MethodMatcher.forName(methodName), resultMatcher, parameterMatcher);
    }

    public static Predicate<Method> forStrictMethodSignature(Method method) {
        Objects.requireNonNull(method);
        return MethodMatcher.forMethodSignature(method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    public static Predicate<Method> forName(String methodName) {
        return method -> Objects.equals(method.getName(), methodName);
    }

    public static Predicate<Method> forNameIgnoreCase(String methodName) {
        return method -> StringKit.endWithIgnoreCase(method.getName(), methodName);
    }

    public static Predicate<Method> forNoneReturnType() {
        return method -> Objects.equals(method.getReturnType(), Void.TYPE);
    }

    public static Predicate<Method> forReturnType(Class<?> returnType) {
        return method -> ClassKit.isAssignable(returnType, method.getReturnType());
    }

    public static Predicate<Method> forStrictReturnType(Class<?> returnType) {
        return method -> Objects.equals(method.getReturnType(), returnType);
    }

    public static Predicate<Method> forNoneParameter() {
        return method -> method.getParameterCount() == 0;
    }

    public static Predicate<Method> forParameterCount(int count) {
        return method -> method.getParameterCount() == count;
    }

    public static Predicate<Method> forParameterTypes(Class<?> ... parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        return method -> ClassKit.isAllAssignableFrom(parameterTypes, method.getParameterTypes());
    }

    public static Predicate<Method> forMostSpecificParameterTypes(Class<?> ... parameterTypes) {
        return MethodMatcher.mostSpecificStrictParameterTypesMatcher(parameterTypes, ClassKit::isAssignable);
    }

    public static Predicate<Method> forMostSpecificStrictParameterTypes(Class<?> ... parameterTypes) {
        return MethodMatcher.mostSpecificStrictParameterTypesMatcher(parameterTypes, Objects::equals);
    }

    public static Predicate<Method> forStrictParameterTypes(Class<?> ... parameterTypes) {
        Objects.requireNonNull(parameterTypes);
        return method -> ArrayKit.equals(method.getParameterTypes(), parameterTypes);
    }

    private static Predicate<Method> mostSpecificStrictParameterTypesMatcher(Class<?>[] parameterTypes, BiPredicate<Class<?>, Class<?>> typeMatcher) {
        Objects.requireNonNull(parameterTypes);
        if (parameterTypes.length == 0) {
            return MethodMatcher.forNoneParameter();
        }
        return method -> {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            if (parameterTypes.length > methodParameterTypes.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class parameterType = parameterTypes[i];
                if (Objects.isNull(parameterType) || !typeMatcher.negate().test(parameterType, methodParameterTypes[i])) continue;
                return false;
            }
            return true;
        };
    }
}

