/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.thread.threadlocal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.core.lang.thread.threadlocal.SpecificThread;

public final class ThreadLocalMap {
    public static final Object UNSET = new Object();
    private static final ThreadLocal<ThreadLocalMap> SLOW_THREAD_LOCAL_MAP = new ThreadLocal();
    private static final AtomicInteger NEXT_INDEX = new AtomicInteger();
    public static final int VARIABLES_TO_REMOVE_INDEX = ThreadLocalMap.nextVariableIndex();
    private Object[] indexedVariables = ThreadLocalMap.newIndexedVariableTable();
    private BitSet cleanerFlags;

    private ThreadLocalMap() {
    }

    public static ThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof SpecificThread) {
            return ThreadLocalMap.fastGet((SpecificThread)thread);
        }
        return ThreadLocalMap.slowGet();
    }

    private static ThreadLocalMap fastGet(SpecificThread thread) {
        ThreadLocalMap threadLocalMap = thread.getThreadLocalMap();
        if (threadLocalMap == null) {
            threadLocalMap = new ThreadLocalMap();
            thread.setThreadLocalMap(threadLocalMap);
        }
        return threadLocalMap;
    }

    private static ThreadLocalMap slowGet() {
        ThreadLocalMap ret = SLOW_THREAD_LOCAL_MAP.get();
        if (ret == null) {
            ret = new ThreadLocalMap();
            SLOW_THREAD_LOCAL_MAP.set(ret);
        }
        return ret;
    }

    public static ThreadLocalMap getIfSet() {
        Thread thread = Thread.currentThread();
        if (thread instanceof SpecificThread) {
            return ((SpecificThread)thread).getThreadLocalMap();
        }
        return SLOW_THREAD_LOCAL_MAP.get();
    }

    public static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof SpecificThread) {
            ((SpecificThread)thread).setThreadLocalMap(null);
        } else {
            SLOW_THREAD_LOCAL_MAP.remove();
        }
    }

    public static void destroy() {
        SLOW_THREAD_LOCAL_MAP.remove();
    }

    public static int nextVariableIndex() {
        int index = NEXT_INDEX.getAndIncrement();
        if (index < 0) {
            NEXT_INDEX.decrementAndGet();
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return index;
    }

    private static Object[] newIndexedVariableTable() {
        Object[] array = new Object[64];
        Arrays.fill(array, UNSET);
        return array;
    }

    public int size() {
        int count = 0;
        Object v = this.indexedVariable(VARIABLES_TO_REMOVE_INDEX);
        if (v != null && v != UNSET) {
            Set variablesToRemove = (Set)v;
            count += variablesToRemove.size();
        }
        return count;
    }

    public boolean isIndexedVariableSet(int index) {
        Object[] lookup = this.indexedVariables;
        return index < lookup.length && lookup[index] != UNSET;
    }

    public Object indexedVariable(int index) {
        Object[] lookup = this.indexedVariables;
        return index < lookup.length ? lookup[index] : UNSET;
    }

    public boolean setIndexedVariable(int index, Object value) {
        Object[] lookup = this.indexedVariables;
        if (index < lookup.length) {
            Object oldValue = lookup[index];
            lookup[index] = value;
            return oldValue == UNSET;
        }
        this.expandIndexedVariableTableAndSet(index, value);
        return true;
    }

    public Object removeIndexedVariable(int index) {
        Object[] lookup = this.indexedVariables;
        if (index < lookup.length) {
            Object v = lookup[index];
            lookup[index] = UNSET;
            return v;
        }
        return UNSET;
    }

    public void setCleanerFlags(int index) {
        if (this.cleanerFlags == null) {
            this.cleanerFlags = new BitSet();
        }
        this.cleanerFlags.set(index);
    }

    public boolean isCleanerFlags(int index) {
        return this.cleanerFlags != null && this.cleanerFlags.get(index);
    }

    private void expandIndexedVariableTableAndSet(int index, Object value) {
        Object[] oldArray = this.indexedVariables;
        int oldCapacity = oldArray.length;
        int newCapacity = index;
        newCapacity |= newCapacity >>> 1;
        newCapacity |= newCapacity >>> 2;
        newCapacity |= newCapacity >>> 4;
        newCapacity |= newCapacity >>> 8;
        newCapacity |= newCapacity >>> 16;
        Object[] newArray = Arrays.copyOf(oldArray, ++newCapacity);
        Arrays.fill(newArray, oldCapacity, newArray.length, UNSET);
        newArray[index] = value;
        this.indexedVariables = newArray;
    }
}

