/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.net.url;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.net.url.RFC3986;
import org.miaixz.bus.core.net.url.UrlDecoder;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class UrlPath {
    private List<CharSequence> segments;
    private boolean withEngTag;

    public static UrlPath of() {
        return new UrlPath();
    }

    public static UrlPath of(CharSequence pathStr, Charset charset) {
        return UrlPath.of().parse(pathStr, charset);
    }

    private static String fixPath(CharSequence path) {
        Assert.notNull(path, "Path segment must be not null!", new Object[0]);
        if ("/".contentEquals(path)) {
            return "";
        }
        String segmentStr = StringKit.trim(path);
        segmentStr = StringKit.removePrefix(segmentStr, "/");
        segmentStr = StringKit.removeSuffix(segmentStr, "/");
        segmentStr = StringKit.trim(segmentStr);
        return segmentStr;
    }

    public UrlPath setWithEndTag(boolean withEngTag) {
        this.withEngTag = withEngTag;
        return this;
    }

    public List<CharSequence> getSegments() {
        return ObjectKit.defaultIfNull(this.segments, ListKit.empty());
    }

    public CharSequence getSegment(int index) {
        if (null == this.segments || index >= this.segments.size()) {
            return null;
        }
        return this.segments.get(index);
    }

    public UrlPath add(CharSequence segment) {
        this.addInternal(UrlPath.fixPath(segment), false);
        return this;
    }

    public UrlPath addBefore(CharSequence segment) {
        this.addInternal(UrlPath.fixPath(segment), true);
        return this;
    }

    public UrlPath parse(CharSequence path, Charset charset) {
        if (StringKit.isNotEmpty(path)) {
            if (StringKit.endWith(path, '/')) {
                this.withEngTag = true;
            }
            if (StringKit.isNotEmpty(path = UrlPath.fixPath(path))) {
                List<String> split = CharsBacker.split(path, "/");
                for (String seg : split) {
                    this.addInternal(UrlDecoder.decodeForPath(seg, charset), false);
                }
            }
        }
        return this;
    }

    public String build(Charset charset) {
        if (CollKit.isEmpty(this.segments)) {
            return this.withEngTag ? "/" : "";
        }
        StringBuilder builder = new StringBuilder();
        for (CharSequence segment : this.segments) {
            builder.append('/').append(RFC3986.SEGMENT.encode(segment, charset, new char[0]));
        }
        if (this.withEngTag) {
            if (StringKit.isEmpty(builder)) {
                builder.append('/');
            } else if (!StringKit.endWith((CharSequence)builder, '/')) {
                builder.append('/');
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private void addInternal(CharSequence segment, boolean before) {
        if (this.segments == null) {
            this.segments = new LinkedList<CharSequence>();
        }
        if (before) {
            this.segments.add(0, segment);
        } else {
            this.segments.add(segment);
        }
    }
}

