/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import java.util.function.Predicate;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.CollKit;

public class CharsValidator {
    public static boolean isBlank(CharSequence text) {
        int length;
        if (text == null || (length = text.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (CharKit.isBlankChar(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence text) {
        int length;
        if (text == null || (length = text.length()) == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (CharKit.isBlankChar(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(CharSequence text) {
        return text == null || text.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence text) {
        return !CharsValidator.isEmpty(text);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        return ArrayKit.hasBlank(strs);
    }

    public static boolean isAllNotBlank(CharSequence ... args) {
        return ArrayKit.isAllNotBlank(args);
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        return ArrayKit.isAllBlank(strs);
    }

    public static boolean hasEmpty(CharSequence ... args) {
        if (ArrayKit.isEmpty(args)) {
            return true;
        }
        for (CharSequence text : args) {
            if (!CharsValidator.isEmpty(text)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEmpty(Iterable<? extends CharSequence> args) {
        if (CollKit.isEmpty(args)) {
            return true;
        }
        for (CharSequence charSequence : args) {
            if (!CharsValidator.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... args) {
        if (ArrayKit.isNotEmpty(args)) {
            for (CharSequence text : args) {
                if (!CharsValidator.isNotEmpty(text)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllEmpty(Iterable<? extends CharSequence> args) {
        if (CollKit.isNotEmpty(args)) {
            for (CharSequence charSequence : args) {
                if (!CharsValidator.isNotEmpty(charSequence)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return !CharsValidator.hasEmpty(args);
    }

    public static boolean isNullOrUndefined(CharSequence text) {
        if (null == text) {
            return true;
        }
        return CharsValidator.isNullOrUndefinedString(text);
    }

    public static boolean isEmptyOrUndefined(CharSequence text) {
        if (CharsValidator.isEmpty(text)) {
            return true;
        }
        return CharsValidator.isNullOrUndefinedString(text);
    }

    public static boolean isBlankOrUndefined(CharSequence text) {
        if (CharsValidator.isBlank(text)) {
            return true;
        }
        return CharsValidator.isNullOrUndefinedString(text);
    }

    private static boolean isNullOrUndefinedString(CharSequence text) {
        String strString = text.toString().trim();
        return "null".equals(strString) || "undefined".equals(strString);
    }

    public static boolean isAllCharMatch(CharSequence value, Predicate<Character> matcher) {
        if (CharsValidator.isBlank(value)) {
            return false;
        }
        int i = value.length();
        while (--i >= 0) {
            if (matcher.test(Character.valueOf(value.charAt(i)))) continue;
            return false;
        }
        return true;
    }
}

