/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import java.io.Serializable;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.StringKit;

public class StringTrimer
implements UnaryOperator<CharSequence>,
Serializable {
    public static final StringTrimer TRIM_BLANK = new StringTrimer(TrimMode.BOTH, CharKit::isBlankChar);
    public static final StringTrimer TRIM_PREFIX_BLANK = new StringTrimer(TrimMode.PREFIX, CharKit::isBlankChar);
    public static final StringTrimer TRIM_SUFFIX_BLANK = new StringTrimer(TrimMode.SUFFIX, CharKit::isBlankChar);
    private static final long serialVersionUID = -1L;
    private final TrimMode mode;
    private final Predicate<Character> predicate;

    public StringTrimer(TrimMode mode, Predicate<Character> predicate) {
        this.mode = mode;
        this.predicate = predicate;
    }

    @Override
    public String apply(CharSequence text) {
        int begin;
        if (StringKit.isEmpty(text)) {
            return StringKit.toStringOrNull(text);
        }
        int length = text.length();
        int end = length;
        if (this.mode == TrimMode.PREFIX || this.mode == TrimMode.BOTH) {
            for (begin = 0; begin < end && this.predicate.test(Character.valueOf(text.charAt(begin))); ++begin) {
            }
        }
        if (this.mode == TrimMode.SUFFIX || this.mode == TrimMode.BOTH) {
            while (begin < end && this.predicate.test(Character.valueOf(text.charAt(end - 1)))) {
                --end;
            }
        }
        String result = begin > 0 || end < length ? text.toString().substring(begin, end) : text.toString();
        return result;
    }

    public static enum TrimMode {
        PREFIX,
        SUFFIX,
        BOTH;

    }
}

