/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.escape;

import org.miaixz.bus.core.text.replacer.StringReplacer;
import org.miaixz.bus.core.xyz.CharKit;

public class NumericEntityUnescaper
extends StringReplacer {
    private static final long serialVersionUID = -1L;

    @Override
    protected int replace(CharSequence text, int pos, StringBuilder out) {
        int len = text.length();
        if (text.charAt(pos) == '&' && pos < len - 2 && text.charAt(pos + 1) == '#') {
            boolean isSemiNext;
            int end;
            int start = pos + 2;
            boolean isHex = false;
            char firstChar = text.charAt(start);
            if (firstChar == 'x' || firstChar == 'X') {
                ++start;
                isHex = true;
            }
            if (start == len) {
                return 0;
            }
            for (end = start; end < len && CharKit.isHexChar(text.charAt(end)); ++end) {
            }
            boolean bl = isSemiNext = end != len && text.charAt(end) == ';';
            if (isSemiNext) {
                int entityValue;
                try {
                    entityValue = isHex ? Integer.parseInt(text.subSequence(start, end).toString(), 16) : Integer.parseInt(text.subSequence(start, end).toString(), 10);
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
                out.append((char)entityValue);
                return 2 + end - start + (isHex ? 1 : 0) + 1;
            }
        }
        return 0;
    }
}

