/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.placeholder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;

public class StringMatcher {
    private final List<String> patterns;

    public StringMatcher(String pattern) {
        this.patterns = StringMatcher.parse(pattern);
    }

    private static List<String> parse(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        int length = pattern.length();
        char c = '\u0000';
        boolean inVar = false;
        StringBuilder part = StringKit.builder();
        for (int i = 0; i < length; ++i) {
            char pre = c;
            c = pattern.charAt(i);
            if (inVar) {
                part.append(c);
                if ('}' != c) continue;
                inVar = false;
                patterns.add(part.toString());
                part.setLength(0);
                continue;
            }
            if ('{' == c && '$' == pre) {
                inVar = true;
                String preText = part.substring(0, part.length() - 1);
                if (StringKit.isNotEmpty(preText)) {
                    patterns.add(preText);
                }
                part.setLength(0);
                part.append(pre).append(c);
                continue;
            }
            part.append(c);
        }
        if (part.length() > 0) {
            patterns.add(part.toString());
        }
        return patterns;
    }

    public Map<String, String> match(String text) {
        HashMap<String, String> result = MapKit.newHashMap(true);
        int from = 0;
        String key = null;
        for (String part : this.patterns) {
            if (StringKit.isWrap((CharSequence)part, "${", "}")) {
                key = StringKit.sub(part, 2, part.length() - 1);
                continue;
            }
            int to = text.indexOf(part, from);
            if (to < 0) {
                return MapKit.empty();
            }
            if (null != key && to > from) {
                result.put(key, text.substring(from, to));
            }
            from = to + part.length();
            key = null;
        }
        if (null != key && from < text.length()) {
            result.put(key, text.substring(from));
        }
        return result;
    }
}

