/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ExceptionKit;
import org.miaixz.bus.core.xyz.StreamKit;

public class AsyncKit {
    public static void waitAll(CompletableFuture<?> ... tasks) {
        try {
            CompletableFuture.allOf(tasks).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalException(e);
        }
    }

    public static <T> T waitAny(CompletableFuture<?> ... tasks) {
        try {
            return (T)CompletableFuture.anyOf(tasks).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalException(e);
        }
    }

    public static <T> T get(CompletableFuture<T> task) {
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new InternalException(e);
        }
    }

    public static <T> List<T> allOfGet(List<CompletableFuture<T>> tasks) {
        Assert.notEmpty(tasks);
        return AsyncKit.allOfGet(tasks, null);
    }

    @SafeVarargs
    public static <T> List<T> allOfGet(CompletableFuture<T> ... tasks) {
        Assert.notEmpty(tasks);
        return AsyncKit.allOfGet(Arrays.asList(tasks), null);
    }

    public static <T> List<T> allOfGet(CompletableFuture<T>[] tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncKit.allOfGet(Arrays.asList(tasks), eHandler);
    }

    public static <T> List<T> allOfGet(List<CompletableFuture<T>> tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncKit.execute(tasks, eHandler, false);
    }

    @SafeVarargs
    public static <T> List<T> parallelAllOfGet(CompletableFuture<T> ... tasks) {
        Assert.notEmpty(tasks);
        return AsyncKit.parallelAllOfGet(Arrays.asList(tasks), null);
    }

    public static <T> List<T> parallelAllOfGet(List<CompletableFuture<T>> tasks) {
        Assert.notEmpty(tasks);
        return AsyncKit.parallelAllOfGet(tasks, null);
    }

    public static <T> List<T> parallelAllOfGet(CompletableFuture<T>[] tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncKit.parallelAllOfGet(Arrays.asList(tasks), eHandler);
    }

    public static <T> List<T> parallelAllOfGet(List<CompletableFuture<T>> tasks, Function<Exception, T> eHandler) {
        Assert.notEmpty(tasks);
        return AsyncKit.execute(tasks, eHandler, true);
    }

    private static <T> List<T> execute(List<CompletableFuture<T>> tasks, Function<Exception, T> eHandler, boolean isParallel) {
        return StreamKit.of(tasks, isParallel).map(e -> {
            try {
                return e.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                if (eHandler != null) {
                    return eHandler.apply(ex);
                }
                throw ExceptionKit.wrapRuntime(ex);
            }
        }).collect(Collectors.toList());
    }
}

