/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.miaixz.bus.core.io.stream.EmptyOutputStream;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;

public class CheckKit {
    public static long checksumCRC32(File file) throws InternalException {
        return CheckKit.checksum(file, (Checksum)new CRC32()).getValue();
    }

    public static long checksumCRC32(InputStream in) throws InternalException {
        return CheckKit.checksum(in, (Checksum)new CRC32()).getValue();
    }

    public static Checksum checksum(File file, Checksum checksum) throws InternalException {
        Assert.notNull(file, "File is null !", new Object[0]);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            return CheckKit.checksum(Files.newInputStream(file.toPath(), new OpenOption[0]), checksum);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static Checksum checksum(InputStream in, Checksum checksum) throws InternalException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        if (null == checksum) {
            checksum = new CRC32();
        }
        try {
            in = new CheckedInputStream(in, checksum);
            IoKit.copy(in, EmptyOutputStream.INSTANCE);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            throw throwable;
        }
        IoKit.closeQuietly(in);
        return checksum;
    }

    public static long checksumValue(InputStream in, Checksum checksum) {
        return CheckKit.checksum(in, checksum).getValue();
    }
}

