/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.miaixz.bus.core.center.iterator.ArrayIterator;
import org.miaixz.bus.core.center.iterator.EnumerationIterator;
import org.miaixz.bus.core.center.iterator.FilterIterator;
import org.miaixz.bus.core.center.iterator.IteratorValidator;
import org.miaixz.bus.core.center.iterator.NodeListIterator;
import org.miaixz.bus.core.center.iterator.TransIterator;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.text.StringJoiner;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IteratorKit
extends IteratorValidator {
    public static <T> Iterator<T> getIter(Iterable<T> iterable) {
        return null == iterable ? null : iterable.iterator();
    }

    public static <K, V> Map<K, V> fieldValueMap(Iterator<V> iter, String fieldName) {
        return MapKit.putAll(new HashMap(), iter, value -> FieldKit.getFieldValue(value, fieldName));
    }

    public static <K, V> Map<K, V> fieldValueAsMap(Iterator<?> iter, String fieldNameForKey, String fieldNameForValue) {
        return MapKit.putAll(new HashMap(), iter, value -> FieldKit.getFieldValue(value, fieldNameForKey), value -> FieldKit.getFieldValue(value, fieldNameForValue));
    }

    public static <V, R> List<R> fieldValueList(Iterable<V> iterable, String fieldName) {
        return IteratorKit.fieldValueList(IteratorKit.getIter(iterable), fieldName);
    }

    public static <V, R> List<R> fieldValueList(Iterator<V> iter, String fieldName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (null != iter) {
            while (iter.hasNext()) {
                V value = iter.next();
                result.add(FieldKit.getFieldValue(value, fieldName));
            }
        }
        return result;
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        return StringJoiner.of(conjunction).append(iterator).toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, String prefix, String suffix) {
        return StringJoiner.of(conjunction, prefix, suffix).setWrapElement(true).append(iterator).toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction, Function<T, ? extends CharSequence> func) {
        if (null == iterator) {
            return null;
        }
        return StringJoiner.of(conjunction).append(iterator, func).toString();
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values) {
        return IteratorKit.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterable<K> keys, Iterable<V> values, boolean isOrder) {
        return IteratorKit.toMap(null == keys ? null : keys.iterator(), null == values ? null : values.iterator(), isOrder);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values) {
        return IteratorKit.toMap(keys, values, false);
    }

    public static <K, V> Map<K, V> toMap(Iterator<K> keys, Iterator<V> values, boolean isOrder) {
        HashMap<K, Object> resultMap = MapKit.newHashMap(isOrder);
        if (IteratorKit.isNotEmpty(keys)) {
            while (keys.hasNext()) {
                resultMap.put(keys.next(), null != values && values.hasNext() ? (Object)values.next() : null);
            }
        }
        return resultMap;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IteratorKit.toListMap(iterable, keyMapper, v -> v);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return IteratorKit.toListMap(MapKit.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, List<V>> toListMap(Map<K, List<V>> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = MapKit.newHashMap();
        }
        if (ObjectKit.isNull(iterable)) {
            return resultMap;
        }
        for (T value : iterable) {
            resultMap.computeIfAbsent(keyMapper.apply(value), k -> new ArrayList()).add(valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> Map<K, V> toMap(Iterable<V> iterable, Function<V, K> keyMapper) {
        return IteratorKit.toMap(iterable, keyMapper, Function.identity());
    }

    public static <T, K, V> Map<K, V> toMap(Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return MapKit.putAll(MapKit.newHashMap(), iterable, keyMapper, valueMapper);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIterator<E>(Objects.requireNonNull(e));
    }

    public static <E> Iterable<E> asIterable(Iterator<E> iter) {
        return () -> iter;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        return IteratorKit.getElementType(IteratorKit.getIter(iterable));
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        if (null == iterator) {
            return null;
        }
        Object ele = IteratorKit.getFirstNoneNull(iterator);
        return null == ele ? null : ele.getClass();
    }

    public static <T> List<T> edit(Iterator<T> iter, UnaryOperator<T> editor) {
        ArrayList<T> result = new ArrayList<T>();
        if (null == iter) {
            return result;
        }
        while (iter.hasNext()) {
            Object modified = null == editor ? iter.next() : editor.apply(iter.next());
            if (null == modified) continue;
            result.add(modified);
        }
        return result;
    }

    public static <E> Iterator<E> remove(Iterator<E> iter, Predicate<E> predicate) {
        if (null == iter || null == predicate) {
            return iter;
        }
        while (iter.hasNext()) {
            if (!predicate.test(iter.next())) continue;
            iter.remove();
        }
        return iter;
    }

    public static <E> List<E> filterToList(Iterator<E> iter, Predicate<E> predicate) {
        return ListKit.of(IteratorKit.filtered(iter, predicate));
    }

    public static <E> FilterIterator<E> filtered(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        return new FilterIterator<E>(iterator, predicate);
    }

    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static <F, T> Iterator<T> trans(Iterator<F> iterator, Function<? super F, ? extends T> function) {
        return new TransIterator<F, T>(iterator, function);
    }

    public static int size(Iterable<?> iterable) {
        if (null == iterable) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return IteratorKit.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        if (iterator != null) {
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        }
        return size;
    }

    public static void clear(Iterator<?> iterator) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public static <E> void forEach(Iterator<E> iterator, Consumer<? super E> consumer) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                E element = iterator.next();
                if (null == consumer) continue;
                consumer.accept(element);
            }
        }
    }

    public static <E> String toString(Iterator<E> iterator) {
        return IteratorKit.toString(iterator, Convert::toStringOrNull);
    }

    public static <E> String toString(Iterator<E> iterator, Function<? super E, String> transFunc) {
        return IteratorKit.toString(iterator, transFunc, ", ", "[", "]");
    }

    public static <E> String toString(Iterator<E> iterator, Function<? super E, String> transFunc, String delimiter, String prefix, String suffix) {
        StringJoiner stringJoiner = StringJoiner.of(delimiter, prefix, suffix);
        stringJoiner.append(iterator, transFunc);
        return stringJoiner.toString();
    }

    public static Iterator<?> getIter(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (ArrayKit.isArray(obj)) {
            return new ArrayIterator(obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().iterator();
        }
        if (obj instanceof NodeList) {
            return new NodeListIterator((NodeList)obj);
        }
        if (obj instanceof Node) {
            return new NodeListIterator(((Node)obj).getChildNodes());
        }
        if (obj instanceof Dictionary) {
            return new EnumerationIterator(((Dictionary)obj).elements());
        }
        try {
            Object iterator = MethodKit.invoke(obj, "iterator", new Object[0]);
            if (iterator instanceof Iterator) {
                return (Iterator)iterator;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new ArrayIterator<Object>(new Object[]{obj});
    }
}

