/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ResourceKit;

public class ManifestKit {
    private static final String[] MANIFEST_NAMES = new String[]{"Manifest.mf", "manifest.mf", "MANIFEST.MF"};

    public static Manifest getManifest(Class<?> cls) throws InternalException {
        URLConnection connection;
        URL url = ResourceKit.getResourceUrl(null, cls);
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (connection instanceof JarURLConnection) {
            JarURLConnection conn = (JarURLConnection)connection;
            return ManifestKit.getManifest(conn);
        }
        return null;
    }

    public static Manifest getManifest(File classpathItem) throws InternalException {
        Manifest manifest;
        block18: {
            manifest = null;
            if (classpathItem.isFile()) {
                try (JarFile jarFile = new JarFile(classpathItem);){
                    manifest = ManifestKit.getManifest(jarFile);
                    break block18;
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
            File metaDir = new File(classpathItem, "META-INF");
            File manifestFile = null;
            if (metaDir.isDirectory()) {
                for (String name : MANIFEST_NAMES) {
                    File mFile = new File(metaDir, name);
                    if (!mFile.isFile()) continue;
                    manifestFile = mFile;
                    break;
                }
            }
            if (null != manifestFile) {
                try (FileInputStream fis = new FileInputStream(manifestFile);){
                    manifest = new Manifest(fis);
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
        }
        return manifest;
    }

    public static Manifest getManifest(JarURLConnection connection) throws InternalException {
        JarFile jarFile;
        try {
            jarFile = connection.getJarFile();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return ManifestKit.getManifest(jarFile);
    }

    public static Manifest getManifest(JarFile jarFile) throws InternalException {
        try {
            return jarFile.getManifest();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

