/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Map;
import org.miaixz.bus.core.bean.copier.ValueProvider;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ReflectKit;

public class RecordKit {
    private static volatile Class<?> RECORD_CLASS;
    private static volatile Method METHOD_GET_RECORD_COMPONENTS;
    private static volatile Method METHOD_COMPONENT_GET_NAME;
    private static volatile Method METHOD_COMPONENT_GET_GENERIC_TYPE;

    public static boolean isRecord(Class<?> clazz) {
        if (Keys.JVM_VERSION < 14) {
            return false;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        if (RECORD_CLASS == null) {
            String superclassName = superClass.getName();
            if ("java.lang.Record".equals(superclassName)) {
                RECORD_CLASS = superClass;
                return true;
            }
            return false;
        }
        return superClass == RECORD_CLASS;
    }

    public static Map.Entry<String, Type>[] getRecordComponents(Class<?> recordClass) {
        if (Keys.JVM_VERSION < 14) {
            return new Map.Entry[0];
        }
        if (null == METHOD_GET_RECORD_COMPONENTS) {
            METHOD_GET_RECORD_COMPONENTS = MethodKit.getMethod(Class.class, "getRecordComponents", new Class[0]);
        }
        Class recordComponentClass = ClassKit.loadClass("java.lang.reflect.RecordComponent");
        if (METHOD_COMPONENT_GET_NAME == null) {
            METHOD_COMPONENT_GET_NAME = MethodKit.getMethod(recordComponentClass, "getName", new Class[0]);
        }
        if (METHOD_COMPONENT_GET_GENERIC_TYPE == null) {
            METHOD_COMPONENT_GET_GENERIC_TYPE = MethodKit.getMethod(recordComponentClass, "getGenericType", new Class[0]);
        }
        Object[] components = (Object[])MethodKit.invoke(recordClass, METHOD_GET_RECORD_COMPONENTS, new Object[0]);
        Map.Entry[] entries = new Map.Entry[components.length];
        for (int i = 0; i < components.length; ++i) {
            entries[i] = new AbstractMap.SimpleEntry<String, Type>((String)MethodKit.invoke(components[i], METHOD_COMPONENT_GET_NAME, new Object[0]), (Type)MethodKit.invoke(components[i], METHOD_COMPONENT_GET_GENERIC_TYPE, new Object[0]));
        }
        return entries;
    }

    public static Object newInstance(Class<?> recordClass, ValueProvider<String> valueProvider) {
        Map.Entry<String, Type>[] recordComponents = RecordKit.getRecordComponents(recordClass);
        Object[] args = new Object[recordComponents.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = valueProvider.value(recordComponents[i].getKey(), recordComponents[i].getValue());
        }
        return ReflectKit.newInstance(recordClass, args);
    }
}

