/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.miaixz.bus.core.center.stream.spliterators.DropWhileSpliterator;
import org.miaixz.bus.core.center.stream.spliterators.IterateSpliterator;
import org.miaixz.bus.core.center.stream.spliterators.TakeWhileSpliterator;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.tree.HierarchyIterator;
import org.miaixz.bus.core.xyz.CollectorKit;

public class StreamKit {
    @SafeVarargs
    public static <T> Stream<T> of(T ... array) {
        return null == array ? Stream.empty() : Stream.of(array);
    }

    public static <T> Stream<T> of(Iterable<T> iterable) {
        return StreamKit.of(iterable, false);
    }

    public static <T> Stream<T> of(Iterable<T> iterable, boolean parallel) {
        if (null == iterable) {
            return Stream.empty();
        }
        return iterable instanceof Collection ? (parallel ? ((Collection)iterable).parallelStream() : ((Collection)iterable).stream()) : StreamSupport.stream(iterable.spliterator(), parallel);
    }

    public static <T> Stream<T> ofIter(Iterator<T> iterator) {
        return StreamKit.ofIter(iterator, false);
    }

    public static <T> Stream<T> ofIter(Iterator<T> iterator, boolean parallel) {
        if (null == iterator) {
            return Stream.empty();
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), parallel);
    }

    public static Stream<String> of(File file) {
        return StreamKit.of(file, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static Stream<String> of(Path path) {
        return StreamKit.of(path, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static Stream<String> of(File file, Charset charset) {
        if (null == file) {
            return Stream.empty();
        }
        return StreamKit.of(file.toPath(), charset);
    }

    public static Stream<String> of(Path path, Charset charset) {
        if (null == path) {
            return Stream.empty();
        }
        try {
            return Files.lines(path, charset);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static <T> Stream<T> of(T seed, UnaryOperator<T> elementCreator, int limit) {
        return Stream.iterate(seed, elementCreator).limit(limit);
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter) {
        if (null == stream) {
            return null;
        }
        return stream.collect(CollectorKit.joining(delimiter));
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        if (null == stream) {
            return null;
        }
        return stream.collect(CollectorKit.joining(delimiter, toStringFunc));
    }

    public static <T> Stream<T> iterate(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        return StreamSupport.stream(IterateSpliterator.of(seed, hasNext, next), false);
    }

    public static <T> Stream<T> iterateHierarchies(T root, Function<T, Collection<T>> discoverer, Predicate<T> filter) {
        return StreamKit.ofIter(HierarchyIterator.breadthFirst(root, discoverer, filter));
    }

    public static <T> Stream<T> iterateHierarchies(T root, Function<T, Collection<T>> discoverer) {
        return StreamKit.ofIter(HierarchyIterator.breadthFirst(root, discoverer));
    }

    public static <T> Stream<T> takeWhile(Stream<T> source, Predicate<? super T> predicate) {
        if (null == source) {
            return Stream.empty();
        }
        Objects.requireNonNull(predicate);
        return StreamKit.createStatefulNewStream(source, TakeWhileSpliterator.create(source.spliterator(), predicate));
    }

    public static <T> Stream<T> dropWhile(Stream<T> source, Predicate<? super T> predicate) {
        if (null == source) {
            return Stream.empty();
        }
        Objects.requireNonNull(predicate);
        return StreamKit.createStatefulNewStream(source, DropWhileSpliterator.of(source.spliterator(), predicate));
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (StreamKit.readAvailable(in, b, off, len) < len) {
            throw new EOFException();
        }
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        while (n > 0L) {
            long count = in.skip(n);
            if (count == 0L) {
                if (in.read() == -1) {
                    throw new EOFException();
                }
                count = 1L;
            }
            n -= count;
        }
    }

    public static int readAvailable(InputStream in, byte[] b, int off, int len) throws IOException {
        int count;
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int wpos = off;
        while (len > 0 && (count = in.read(b, wpos, len)) >= 0) {
            wpos += count;
            len -= count;
        }
        return wpos - off;
    }

    private static <T, R> Stream<R> createStatefulNewStream(Stream<T> source, Spliterator<R> newSpliterator) {
        Stream<R> newStream = StreamSupport.stream(newSpliterator, source.isParallel());
        if (source.isParallel()) {
            newStream = newStream.limit(Long.MAX_VALUE);
        }
        return (Stream)newStream.onClose(source::close);
    }
}

