/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xml.XmlMapper;
import org.miaixz.bus.core.xml.XmlSaxReader;
import org.miaixz.bus.core.xml.XmlWriter;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class XmlKit {
    public static final Pattern INVALID_PATTERN = Pattern.compile("[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]");
    public static final Pattern COMMENT_PATTERN = Pattern.compile("(?s)<!--.+?-->");

    public static Document readXml(String pathOrContent) {
        if (StringKit.startWith((CharSequence)(pathOrContent = StringKit.trim(pathOrContent)), '<')) {
            return XmlKit.parseXml(pathOrContent);
        }
        return XmlKit.readXml(FileKit.file(pathOrContent));
    }

    public static Document readXml(File file) {
        Document document;
        block10: {
            Assert.notNull(file, "Xml file is null !", new Object[0]);
            if (!file.exists()) {
                throw new InternalException("File [{}] not a exist!", file.getAbsolutePath());
            }
            if (!file.isFile()) {
                throw new InternalException("[{}] not a file!", file.getAbsolutePath());
            }
            BufferedInputStream in = FileKit.getInputStream(file);
            try {
                document = XmlKit.readXml(in);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
            in.close();
        }
        return document;
    }

    public static Document readXml(InputStream inputStream) throws InternalException {
        return XmlKit.readXml(new InputSource(inputStream), true);
    }

    public static Document readXml(Reader reader) throws InternalException {
        return XmlKit.readXml(new InputSource(reader), true);
    }

    public static Document readXml(InputSource source, boolean namespaceAware) {
        DocumentBuilder builder = org.miaixz.bus.core.xml.DocumentBuilder.createDocumentBuilder(namespaceAware);
        try {
            return builder.parse(source);
        }
        catch (Exception e) {
            throw new InternalException(e, "Parse XML from stream error!", new Object[0]);
        }
    }

    public static Document parseXml(String xmlStr) {
        if (StringKit.isBlank(xmlStr)) {
            throw new IllegalArgumentException("XML content string is blank !");
        }
        return XmlKit.readXml(StringKit.getReader(XmlKit.cleanInvalid(xmlStr)));
    }

    public static void readBySax(File file, ContentHandler contentHandler) {
        BufferedInputStream in = null;
        try {
            in = FileKit.getInputStream(file);
            XmlKit.readBySax(new InputSource(in), contentHandler);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(in);
            throw throwable;
        }
        IoKit.closeQuietly(in);
    }

    public static void readBySax(Reader reader, ContentHandler contentHandler) {
        try {
            XmlKit.readBySax(new InputSource(reader), contentHandler);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(reader);
            throw throwable;
        }
        IoKit.closeQuietly(reader);
    }

    public static void readBySax(InputStream source, ContentHandler contentHandler) {
        try {
            XmlKit.readBySax(new InputSource(source), contentHandler);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(source);
            throw throwable;
        }
        IoKit.closeQuietly(source);
    }

    public static void readBySax(InputSource source, ContentHandler contentHandler) {
        XmlSaxReader.of(source).read(contentHandler);
    }

    public static String toString(Node doc) {
        return XmlKit.toString(doc, false);
    }

    public static String toString(Node doc, boolean isPretty) {
        return XmlKit.toString(doc, org.miaixz.bus.core.lang.Charset.UTF_8, isPretty);
    }

    public static String toString(Node doc, Charset charset, boolean isPretty) {
        return XmlKit.toString(doc, charset, isPretty, false);
    }

    public static String toString(Node doc, Charset charset, boolean isPretty, boolean omitXmlDeclaration) {
        StringWriter writer = StringKit.getWriter();
        XmlKit.write(doc, writer, charset, isPretty ? 2 : 0, omitXmlDeclaration);
        return writer.toString();
    }

    public static String format(Document doc) {
        return XmlKit.toString(doc, true);
    }

    public static String format(String xmlStr) {
        return XmlKit.format(XmlKit.parseXml(xmlStr));
    }

    public static void write(Document doc, File file, Charset charset) {
        XmlWriter.of(doc).setCharset(charset).setIndent(2).setOmitXmlDeclaration(false).write(file);
    }

    public static void write(Node node, Writer writer, Charset charset, int indent) {
        XmlKit.write(node, writer, charset, indent, false);
    }

    public static void write(Node node, Writer writer, Charset charset, int indent, boolean omitXmlDeclaration) {
        XmlWriter.of(node).setCharset(charset).setIndent(indent).setOmitXmlDeclaration(omitXmlDeclaration).write(writer);
    }

    public static void write(Node node, OutputStream out, Charset charset, int indent) {
        XmlKit.write(node, out, charset, indent, false);
    }

    public static void write(Node node, OutputStream out, Charset charset, int indent, boolean omitXmlDeclaration) {
        XmlWriter.of(node).setCharset(charset).setIndent(indent).setOmitXmlDeclaration(omitXmlDeclaration).write(out);
    }

    public static Document createXml() {
        return org.miaixz.bus.core.xml.DocumentBuilder.createDocumentBuilder(true).newDocument();
    }

    public static Document createXml(String rootElementName) {
        return XmlKit.createXml(rootElementName, null);
    }

    public static Document createXml(String rootElementName, String namespace) {
        Document doc = XmlKit.createXml();
        doc.appendChild(null == namespace ? doc.createElement(rootElementName) : doc.createElementNS(namespace, rootElementName));
        return doc;
    }

    public static Element getRootElement(Document doc) {
        return null == doc ? null : doc.getDocumentElement();
    }

    public static Document getOwnerDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return PatternKit.replaceAll((CharSequence)xmlContent, INVALID_PATTERN, "");
    }

    public static String cleanComment(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return PatternKit.replaceAll((CharSequence)xmlContent, COMMENT_PATTERN, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = StringKit.isBlank(tagName) ? element.getChildNodes() : element.getElementsByTagName(tagName);
        return XmlKit.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        int length = nodeList.getLength();
        if (length < 1) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlKit.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlKit.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlKit.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (1 != node.getNodeType()) continue;
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    public static void writeObjectAsXml(File dest, Object bean) {
        XMLEncoder xmlenc = null;
        try {
            xmlenc = new XMLEncoder(FileKit.getOutputStream(dest));
            xmlenc.writeObject(bean);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(xmlenc);
            throw throwable;
        }
        IoKit.closeQuietly(xmlenc);
    }

    public static <T> T xmlToBean(Node node, Class<T> beanClass) {
        return XmlMapper.of(node).toBean(beanClass);
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlKit.xmlToMap(xmlStr, new LinkedHashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(String xmlStr, Map<String, Object> result) {
        Document doc = XmlKit.parseXml(xmlStr);
        Element root = XmlKit.getRootElement(doc);
        root.normalize();
        return XmlKit.xmlToMap(root, result);
    }

    public static Map<String, Object> xmlToMap(Node node) {
        return XmlKit.xmlToMap(node, new LinkedHashMap<String, Object>());
    }

    public static Map<String, Object> xmlToMap(Node node, Map<String, Object> result) {
        XmlMapper.of(node).toMap(result);
        return result;
    }

    public static String mapToXmlString(Map<?, ?> data) {
        return XmlKit.toString(XmlKit.mapToXml(data, "xml"));
    }

    public static String mapToXmlString(Map<?, ?> data, boolean omitXmlDeclaration) {
        return XmlKit.toString(XmlKit.mapToXml(data, "xml"), org.miaixz.bus.core.lang.Charset.UTF_8, false, omitXmlDeclaration);
    }

    public static String mapToXmlString(Map<?, ?> data, String rootName) {
        return XmlKit.toString(XmlKit.mapToXml(data, rootName));
    }

    public static String mapToXmlString(Map<?, ?> data, String rootName, String namespace) {
        return XmlKit.toString(XmlKit.mapToXml(data, rootName, namespace));
    }

    public static String mapToXmlString(Map<?, ?> data, String rootName, String namespace, boolean omitXmlDeclaration) {
        return XmlKit.toString(XmlKit.mapToXml(data, rootName, namespace), org.miaixz.bus.core.lang.Charset.UTF_8, false, omitXmlDeclaration);
    }

    public static String mapToXmlString(Map<?, ?> data, String rootName, String namespace, boolean isPretty, boolean omitXmlDeclaration) {
        return XmlKit.toString(XmlKit.mapToXml(data, rootName, namespace), org.miaixz.bus.core.lang.Charset.UTF_8, isPretty, omitXmlDeclaration);
    }

    public static String mapToXmlString(Map<?, ?> data, String rootName, String namespace, Charset charset, boolean isPretty, boolean omitXmlDeclaration) {
        return XmlKit.toString(XmlKit.mapToXml(data, rootName, namespace), charset, isPretty, omitXmlDeclaration);
    }

    public static Document mapToXml(Map<?, ?> data, String rootName) {
        return XmlKit.mapToXml(data, rootName, null);
    }

    public static Document mapToXml(Map<?, ?> data, String rootName, String namespace) {
        Document doc = XmlKit.createXml();
        Element root = XmlKit.appendChild(doc, rootName, namespace);
        XmlKit.appendMap(doc, root, data);
        return doc;
    }

    public static Document beanToXml(Object bean) {
        return XmlKit.beanToXml(bean, null);
    }

    public static Document beanToXml(Object bean, String namespace) {
        return XmlKit.beanToXml(bean, namespace, false);
    }

    public static Document beanToXml(Object bean, String namespace, boolean ignoreNull) {
        if (null == bean) {
            return null;
        }
        return XmlKit.mapToXml(BeanKit.beanToMap(bean, false, ignoreNull), bean.getClass().getSimpleName(), namespace);
    }

    public static boolean isElement(Node node) {
        return null != node && 1 == node.getNodeType();
    }

    public static Element appendChild(Node node, String tagName) {
        return XmlKit.appendChild(node, tagName, null);
    }

    public static Element appendChild(Node node, String tagName, String namespace) {
        Document doc = XmlKit.getOwnerDocument(node);
        Element child = null == namespace ? doc.createElement(tagName) : doc.createElementNS(namespace, tagName);
        node.appendChild(child);
        return child;
    }

    public static Node appendText(Node node, CharSequence text) {
        return XmlKit.appendText(XmlKit.getOwnerDocument(node), node, text);
    }

    public static void append(Node node, Object data) {
        XmlKit.append(XmlKit.getOwnerDocument(node), node, data);
    }

    private static void append(Document doc, Node node, Object data) {
        if (data instanceof Map) {
            XmlKit.appendMap(doc, node, (Map)data);
        } else if (data instanceof Iterator) {
            XmlKit.appendIterator(doc, node, (Iterator)data);
        } else if (data instanceof Iterable) {
            XmlKit.appendIterator(doc, node, ((Iterable)data).iterator());
        } else {
            XmlKit.appendText(doc, node, data.toString());
        }
    }

    private static void appendMap(Document doc, Node node, Map data) {
        data.forEach((key, value) -> {
            if (null != key) {
                Element child = XmlKit.appendChild(node, key.toString());
                if (null != value) {
                    XmlKit.append(doc, child, value);
                }
            }
        });
    }

    private static void appendIterator(Document doc, Node node, Iterator data) {
        Node parentNode = node.getParentNode();
        boolean isFirst = true;
        while (data.hasNext()) {
            Object eleData = data.next();
            if (isFirst) {
                XmlKit.append(doc, node, eleData);
                isFirst = false;
                continue;
            }
            Node cloneNode = node.cloneNode(false);
            parentNode.appendChild(cloneNode);
            XmlKit.append(doc, cloneNode, eleData);
        }
    }

    private static Node appendText(Document doc, Node node, CharSequence text) {
        return node.appendChild(doc.createTextNode(StringKit.toStringOrEmpty(text)));
    }
}

