/*
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~                                                                               ~
 ~ The MIT License (MIT)                                                         ~
 ~                                                                               ~
 ~ Copyright (c) 2015-2025 miaixz.org and other contributors.                    ~
 ~                                                                               ~
 ~ Permission is hereby granted, free of charge, to any person obtaining a copy  ~
 ~ of this software and associated documentation files (the "Software"), to deal ~
 ~ in the Software without restriction, including without limitation the rights  ~
 ~ to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     ~
 ~ copies of the Software, and to permit persons to whom the Software is         ~
 ~ furnished to do so, subject to the following conditions:                      ~
 ~                                                                               ~
 ~ The above copyright notice and this permission notice shall be included in    ~
 ~ all copies or substantial portions of the Software.                           ~
 ~                                                                               ~
 ~ THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    ~
 ~ IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      ~
 ~ FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   ~
 ~ AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        ~
 ~ LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ~
 ~ OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     ~
 ~ THE SOFTWARE.                                                                 ~
 ~                                                                               ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
*/
package org.miaixz.bus.core.basic.normal;

import org.miaixz.bus.core.lang.Normal;

/**
 * 业务常量
 *
 * @author Kimi Liu
 * @since Java 17+
 */
public class Consts extends Normal {

    /**
     * 全局状态
     */
    public static final Integer STATUS_MINUS_ONE = -1;
    public static final Integer STATUS_ZERO = 0;
    public static final Integer STATUS_ONE = 1;
    public static final Integer STATUS_TWO = 2;
    public static final Integer STATUS_THREE = 3;
    public static final Integer STATUS_FOUR = 4;
    public static final Integer STATUS_FIVE = 5;
    public static final Integer STATUS_SIX = 6;
    public static final Integer STATUS_SEVEN = 7;
    public static final Integer STATUS_EIGHT = 8;
    public static final Integer STATUS_NINE = 9;

    /**
     * 全局类型
     */
    public static final Integer TYPE_MINUS_ONE = -1;
    public static final Integer TYPE_ZERO = 0;
    public static final Integer TYPE_ONE = 1;
    public static final Integer TYPE_TWO = 2;
    public static final Integer TYPE_THREE = 3;
    public static final Integer TYPE_FOUR = 4;
    public static final Integer TYPE_FIVE = 5;
    public static final Integer TYPE_SIX = 6;
    public static final Integer TYPE_SEVEN = 7;
    public static final Integer TYPE_EIGHT = 8;
    public static final Integer TYPE_NINE = 9;

    /**
     * 响应码
     */
    public static final String RESULT_ERRCODE = "errcode";

    /**
     * 响应码描述
     */
    public static final String RESULT_ERRMSG = "errmsg";

    /**
     * 返回数据
     */
    public static final String RESULT_DATA = "data";

}
