/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Keys;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Context
extends Keys {
    public static final Context INSTANCE = new Context();
    public final Properties delegate = new Properties();

    public Context() {
    }

    public Context(Properties properties) {
        this.delegate.putAll((Map<?, ?>)properties);
    }

    public static Context newInstance(Properties properties) {
        return new Context(properties);
    }

    public Set<String> keys() {
        return this.delegate.stringPropertyNames();
    }

    public void putAll(Properties properties) {
        this.delegate.putAll((Map<?, ?>)properties);
    }

    public String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    public int getProperty(String key, int defaultValue) {
        return Convert.toInt(this.getProperty(key), defaultValue);
    }

    public boolean getProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return BooleanKit.toBoolean(value);
    }

    public Map<String, Properties> group(String group) {
        Set<String> keys = this.keys();
        Set<String> inner = keys.stream().filter(i -> i.startsWith(group)).collect(Collectors.toSet());
        if (CollKit.isEmpty(inner)) {
            return Collections.emptyMap();
        }
        HashMap<String, Properties> map = MapKit.newHashMap();
        inner.forEach(i -> {
            Properties p = new Properties();
            String key = i.substring(group.length()) + ":";
            int keyIndex = key.length();
            keys.stream().filter(j -> j.startsWith(key)).forEach(j -> p.setProperty(j.substring(keyIndex), this.delegate.getProperty((String)j)));
            map.put(this.delegate.getProperty((String)i), p);
        });
        return map;
    }

    public Context whenNotBlank(String key, Consumer<String> consumer) {
        String value = this.delegate.getProperty(key);
        if (StringKit.isNotBlank(value)) {
            consumer.accept(value);
        }
        return this;
    }

    public <T> Context whenNotBlank(String key, Function<String, T> function, Consumer<T> consumer) {
        String value = this.delegate.getProperty(key);
        if (StringKit.isNotBlank(value)) {
            consumer.accept(function.apply(value));
        }
        return this;
    }
}

