/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.bean.desc.PropDesc;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.BeanException;
import org.miaixz.bus.core.lang.exception.CloneException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ReflectKit;

public class DynaBean
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2852291223632L;
    private final Class<?> beanClass;
    private Object bean;

    public DynaBean(Object bean) {
        Assert.notNull(bean);
        if (bean instanceof DynaBean) {
            this.bean = ((DynaBean)bean).getBean();
            this.beanClass = ((DynaBean)bean).getBeanClass();
        } else if (bean instanceof Class) {
            this.bean = ReflectKit.newInstance((Class)bean, new Object[0]);
            this.beanClass = (Class)bean;
        } else {
            this.bean = bean;
            this.beanClass = ClassKit.getClass(bean);
        }
    }

    public static DynaBean of(Class<?> beanClass, Object ... params) {
        return DynaBean.of(ReflectKit.newInstance(beanClass, params));
    }

    public static DynaBean of(Object bean) {
        return new DynaBean(bean);
    }

    public <T> T get(String fieldName) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return (T)((Map)this.bean).get(fieldName);
        }
        if (this.bean instanceof Collection) {
            try {
                return CollKit.get((Collection)this.bean, Integer.parseInt(fieldName));
            }
            catch (NumberFormatException e) {
                return (T)CollKit.map((Collection)this.bean, beanEle -> DynaBean.of(beanEle).get(fieldName), false);
            }
        }
        if (ArrayKit.isArray(this.bean)) {
            try {
                return (T)ArrayKit.get(this.bean, Integer.parseInt(fieldName));
            }
            catch (NumberFormatException e) {
                return (T)ArrayKit.map(this.bean, Object.class, beanEle -> DynaBean.of(beanEle).get(fieldName));
            }
        }
        PropDesc prop = BeanKit.getBeanDesc(this.beanClass).getProp(fieldName);
        if (null == prop) {
            return null;
        }
        return (T)prop.getValue(this.bean, false);
    }

    public boolean containsProp(String fieldName) {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return ((Map)this.bean).containsKey(fieldName);
        }
        if (this.bean instanceof Collection) {
            return CollKit.size(this.bean) > Integer.parseInt(fieldName);
        }
        return null != BeanKit.getBeanDesc(this.beanClass).getProp(fieldName);
    }

    public <T> T safeGet(String fieldName) {
        try {
            return this.get(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DynaBean set(String fieldName, Object value) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(fieldName, value);
        } else if (this.bean instanceof List) {
            ListKit.setOrPadding((List)this.bean, Convert.toInt(fieldName), value);
        } else if (ArrayKit.isArray(this.bean)) {
            this.bean = ArrayKit.setOrPadding(this.bean, Convert.toInt(fieldName), value);
        } else {
            PropDesc prop = BeanKit.getBeanDesc(this.beanClass).getProp(fieldName);
            if (null == prop) {
                throw new BeanException("No public field or set method for '{}'", new Object[]{fieldName});
            }
            prop.setValue(this.bean, value, false, false);
        }
        return this;
    }

    public Object invoke(String methodName, Object ... params) {
        return MethodKit.invoke(this.bean, methodName, params);
    }

    public <T> T getBean() {
        return (T)this.bean;
    }

    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DynaBean other = (DynaBean)object;
        if (this.bean == null) {
            return other.bean == null;
        }
        return this.bean.equals(other.bean);
    }

    public String toString() {
        return this.bean.toString();
    }

    public DynaBean clone() {
        try {
            return (DynaBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

