/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.bean.copier.AbstractCopier;
import org.miaixz.bus.core.bean.copier.CopyOptions;
import org.miaixz.bus.core.bean.desc.PropDesc;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.BeanException;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class BeanToBeanCopier<S, T>
extends AbstractCopier<S, T> {
    private final Type targetType;

    public BeanToBeanCopier(S source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Map<String, PropDesc> targetPropDescMap;
        CopyOptions copyOptions = this.copyOptions;
        Class<?> actualEditable = this.target.getClass();
        if (null != copyOptions.editable) {
            Assert.isTrue(copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), copyOptions.editable.getName());
            actualEditable = copyOptions.editable;
        }
        if (MapKit.isEmpty(targetPropDescMap = this.getBeanDesc(actualEditable).getPropMap(copyOptions.ignoreCase))) {
            if (copyOptions.ignoreError) {
                return (T)this.target;
            }
            throw new BeanException("No properties for target: {}", actualEditable);
        }
        Map<String, PropDesc> sourcePropDescMap = this.getBeanDesc(this.source.getClass()).getPropMap(copyOptions.ignoreCase);
        if (MapKit.isEmpty(sourcePropDescMap)) {
            if (copyOptions.ignoreError) {
                return (T)this.target;
            }
            throw new BeanException("No properties for source: {}", this.source.getClass());
        }
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source, copyOptions.ignoreError);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<Object, Object> entry = copyOptions.editField(sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = StringKit.toStringOrNull(entry.getKey());
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            PropDesc tDesc = copyOptions.findPropDesc(targetPropDescMap, (String)sFieldName);
            if (null == tDesc || !tDesc.isWritable(copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = TypeKit.getActualType(this.targetType, tDesc.getFieldType());
            sValue = copyOptions.convertField(fieldType, sValue);
            tDesc.setValue(this.target, sValue, copyOptions.ignoreNullValue, copyOptions.ignoreError, copyOptions.override);
        });
        return (T)this.target;
    }
}

