/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.miaixz.bus.core.bean.copier.AbstractCopier;
import org.miaixz.bus.core.bean.copier.CopyOptions;
import org.miaixz.bus.core.bean.copier.ValueProvider;
import org.miaixz.bus.core.bean.desc.PropDesc;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class ValueToBeanCopier<T>
extends AbstractCopier<ValueProvider<String>, T> {
    private final Type targetType;

    public ValueToBeanCopier(ValueProvider<String> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = this.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        targetPropDescMap.forEach((tFieldName, propDesc) -> {
            if (null == tFieldName) {
                return;
            }
            if (null == propDesc || !propDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            MutableEntry<Object, Object> entry = this.copyOptions.editField(tFieldName, null);
            if (null == entry) {
                return;
            }
            tFieldName = StringKit.toStringOrNull(entry.getKey());
            if (null == tFieldName) {
                return;
            }
            if (!((ValueProvider)this.source).containsKey(tFieldName)) {
                return;
            }
            Type fieldType = TypeKit.getActualType(this.targetType, propDesc.getFieldType());
            Object sValue = ((ValueProvider)this.source).value(tFieldName, fieldType);
            if (!this.copyOptions.testPropertyFilter(propDesc.getField(), sValue)) {
                return;
            }
            propDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

