/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.desc;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.core.lang.annotation.Ignore;
import org.miaixz.bus.core.lang.exception.BeanException;
import org.miaixz.bus.core.lang.reflect.Invoker;
import org.miaixz.bus.core.lang.reflect.field.FieldInvoker;
import org.miaixz.bus.core.lang.reflect.method.MethodInvoker;
import org.miaixz.bus.core.xyz.AnnoKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.ModifierKit;

public class PropDesc {
    protected Invoker getter;
    protected Invoker setter;
    private String fieldName;
    private Invoker field;
    private Boolean hasTransientForGetter;
    private Boolean hasTransientForSetter;
    private Boolean isReadable;
    private Boolean isWritable;

    public PropDesc(Field field, Method getter, Method setter) {
        this(FieldKit.getFieldName(field), getter, setter);
        this.field = FieldInvoker.of(field);
    }

    public PropDesc(String fieldName, Method getter, Method setter) {
        this(fieldName, MethodInvoker.of(getter), MethodInvoker.of(setter));
    }

    public PropDesc(String fieldName, Invoker getter, Invoker setter) {
        this.fieldName = fieldName;
        this.getter = getter;
        this.setter = setter;
    }

    private static boolean isIgnoreGet(Field field, Method getter) {
        return AnnoKit.hasAnnotation((AnnotatedElement)field, Ignore.class) || AnnoKit.hasAnnotation((AnnotatedElement)getter, Ignore.class);
    }

    private static boolean isIgnoreSet(Field field, Method setter) {
        return AnnoKit.hasAnnotation((AnnotatedElement)field, Ignore.class) || AnnoKit.hasAnnotation((AnnotatedElement)setter, Ignore.class);
    }

    private static boolean isTransientForGet(Field field, Method getter) {
        boolean isTransient = ModifierKit.hasAny(field, EnumValue.Modifier.TRANSIENT);
        if (!isTransient && null != getter && !(isTransient = ModifierKit.hasAny(getter, EnumValue.Modifier.TRANSIENT))) {
            isTransient = AnnoKit.hasAnnotation((AnnotatedElement)getter, "java.beans.Transient");
        }
        return isTransient;
    }

    private static boolean isTransientForSet(Field field, Method setter) {
        boolean isTransient = ModifierKit.hasAny(field, EnumValue.Modifier.TRANSIENT);
        if (!isTransient && null != setter && !(isTransient = ModifierKit.hasAny(setter, EnumValue.Modifier.TRANSIENT))) {
            isTransient = AnnoKit.hasAnnotation((AnnotatedElement)setter, "java.beans.Transient");
        }
        return isTransient;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getRawFieldName() {
        if (null == this.field) {
            return this.fieldName;
        }
        return this.field.getName();
    }

    public Field getField() {
        if (null != this.field && this.field instanceof FieldInvoker) {
            return ((FieldInvoker)this.field).getField();
        }
        return null;
    }

    public Type getFieldType() {
        if (null != this.field) {
            return this.field.getType();
        }
        return this.findPropType(this.getter, this.setter);
    }

    public Class<?> getFieldClass() {
        if (null != this.field) {
            return this.field.getTypeClass();
        }
        return this.findPropClass(this.getter, this.setter);
    }

    public Invoker getGetter() {
        return this.getter;
    }

    public Invoker getSetter() {
        return this.setter;
    }

    public boolean isReadable(boolean checkTransient) {
        this.cacheReadable();
        if (checkTransient && this.hasTransientForGetter.booleanValue()) {
            return false;
        }
        return this.isReadable;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError) {
        return this.setValue(bean, value, ignoreNull, ignoreError, true);
    }

    public Object getValue(Object bean, boolean ignoreError) {
        block4: {
            try {
                if (null != this.getter) {
                    return this.getter.invoke(bean, new Object[0]);
                }
                if (null != this.field) {
                    return this.field.invoke(bean, new Object[0]);
                }
            }
            catch (Exception e) {
                if (ignoreError) break block4;
                throw new BeanException(e, "Get value of [{}] error!", this.getFieldName());
            }
        }
        return null;
    }

    public String toString() {
        return "PropDesc{field=" + String.valueOf(this.field) + ", fieldName=" + this.fieldName + ", getter=" + String.valueOf(this.getter) + ", setter=" + String.valueOf(this.setter) + "}";
    }

    public Object getValue(Object bean, Type targetType, boolean ignoreError) {
        Object result = this.getValue(bean, ignoreError);
        if (null != result && null != targetType) {
            return Convert.convertWithCheck(targetType, result, null, ignoreError);
        }
        return result;
    }

    public boolean isWritable(boolean checkTransient) {
        this.cacheWritable();
        if (checkTransient && this.hasTransientForSetter.booleanValue()) {
            return false;
        }
        return this.isWritable;
    }

    public PropDesc setValue(Object bean, Object value) {
        if (null != this.setter) {
            this.setter.invoke(bean, value);
        } else if (null != this.field) {
            this.field.invoke(bean, value);
        }
        return this;
    }

    public PropDesc setValue(Object bean, Object value, boolean ignoreNull, boolean ignoreError, boolean override) {
        block6: {
            Class<?> propClass;
            if (null == value && ignoreNull) {
                return this;
            }
            if (!override && null != this.getValue(bean, ignoreError)) {
                return this;
            }
            if (null != value && !(propClass = this.getFieldClass()).isInstance(value)) {
                value = Convert.convertWithCheck(propClass, value, null, ignoreError);
            }
            if (null != value || !ignoreNull) {
                try {
                    this.setValue(bean, value);
                }
                catch (Exception e) {
                    if (ignoreError) break block6;
                    throw new BeanException(e, "Set value of [{}] error!", this.getFieldName());
                }
            }
        }
        return this;
    }

    private void cacheReadable() {
        if (null != this.isReadable) {
            return;
        }
        Field field = null;
        if (this.field instanceof FieldInvoker) {
            field = ((FieldInvoker)this.field).getField();
        }
        Method getterMethod = null;
        if (this.getter instanceof MethodInvoker) {
            getterMethod = ((MethodInvoker)this.getter).getMethod();
        }
        this.hasTransientForGetter = PropDesc.isTransientForGet(field, getterMethod);
        if (PropDesc.isIgnoreGet(field, getterMethod)) {
            this.isReadable = false;
            return;
        }
        this.isReadable = null != getterMethod || ModifierKit.isPublic(field);
    }

    private void cacheWritable() {
        if (null != this.isWritable) {
            return;
        }
        Field field = null;
        if (this.field instanceof FieldInvoker) {
            field = ((FieldInvoker)this.field).getField();
        }
        Method setterMethod = null;
        if (this.setter instanceof MethodInvoker) {
            setterMethod = ((MethodInvoker)this.setter).getMethod();
        }
        this.hasTransientForSetter = PropDesc.isTransientForSet(field, setterMethod);
        if (PropDesc.isIgnoreSet(field, setterMethod)) {
            this.isWritable = false;
            return;
        }
        this.isWritable = null != setterMethod || ModifierKit.isPublic(field);
    }

    private Type findPropType(Invoker getter, Invoker setter) {
        Type type = null;
        if (null != getter) {
            type = getter.getType();
        }
        if (null == type && null != setter) {
            type = setter.getType();
        }
        return type;
    }

    private Class<?> findPropClass(Invoker getter, Invoker setter) {
        Class<?> type = null;
        if (null != getter) {
            type = getter.getTypeClass();
        }
        if (null == type && null != setter) {
            type = setter.getTypeClass();
        }
        return type;
    }
}

