/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.desc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.miaixz.bus.core.bean.desc.AbstractBeanDesc;
import org.miaixz.bus.core.bean.desc.PropDesc;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.BooleanKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.ModifierKit;
import org.miaixz.bus.core.xyz.StringKit;

public class StrictBeanDesc
extends AbstractBeanDesc {
    private static final long serialVersionUID = 2852227769103L;
    private final boolean ignoreCase;
    private final boolean isMatchPrimitive;

    public StrictBeanDesc(Class<?> beanClass) {
        this(beanClass, true, false);
    }

    public StrictBeanDesc(Class<?> beanClass, boolean ignoreCase, boolean isMatchPrimitive) {
        super(beanClass);
        this.ignoreCase = ignoreCase;
        this.isMatchPrimitive = isMatchPrimitive;
        this.init();
    }

    private static Method getGetterForBoolean(Method[] gettersOrSetters, String fieldName, boolean ignoreCase) {
        return MethodKit.getMethod(gettersOrSetters, m -> {
            if (0 != m.getParameterCount() || !BooleanKit.isBoolean(m.getReturnType())) {
                return false;
            }
            if (StringKit.startWith(fieldName, "is", ignoreCase) && StringKit.equals(fieldName, m.getName(), ignoreCase)) {
                return true;
            }
            return StringKit.equals(StringKit.upperFirstAndAddPre(fieldName, "is"), m.getName(), ignoreCase);
        });
    }

    private static Method getSetterForBoolean(Method[] gettersOrSetters, String fieldName, boolean ignoreCase) {
        return MethodKit.getMethod(gettersOrSetters, m -> {
            if (1 != m.getParameterCount() || !BooleanKit.isBoolean(m.getParameterTypes()[0])) {
                return false;
            }
            if (StringKit.startWith(fieldName, "is", ignoreCase)) {
                return StringKit.equals("set" + StringKit.removePrefix(fieldName, "is", ignoreCase), m.getName(), ignoreCase);
            }
            return false;
        });
    }

    private void init() {
        Field[] fields;
        Class beanClass = this.beanClass;
        Map propMap = this.propMap;
        Method[] gettersAndSetters = MethodKit.getPublicMethods(beanClass, MethodKit::isGetterOrSetterIgnoreCase);
        for (Field field2 : fields = FieldKit.getFields(beanClass, field -> !ModifierKit.isStatic(field) && !FieldKit.isOuterClassField(field))) {
            PropDesc prop = this.createProp(field2, gettersAndSetters);
            propMap.putIfAbsent(prop.getFieldName(), prop);
        }
    }

    private PropDesc createProp(Field field, Method[] methods) {
        PropDesc prop = this.findProp(field, methods, false);
        if (this.ignoreCase && (null == prop.getter || null == prop.setter)) {
            PropDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropDesc findProp(Field field, Method[] gettersOrSetters, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = BooleanKit.isBoolean(fieldType);
        Method[] getterAndSetter = this.findGetterAndSetter(fieldName, fieldType, gettersOrSetters, ignoreCase);
        if (isBooleanField) {
            if (null == getterAndSetter[0]) {
                getterAndSetter[0] = StrictBeanDesc.getGetterForBoolean(gettersOrSetters, fieldName, ignoreCase);
            }
            if (null == getterAndSetter[1]) {
                getterAndSetter[1] = StrictBeanDesc.getSetterForBoolean(gettersOrSetters, fieldName, ignoreCase);
            }
        }
        return new PropDesc(field, getterAndSetter[0], getterAndSetter[1]);
    }

    private Method[] findGetterAndSetter(String fieldName, Class<?> fieldType, Method[] gettersOrSetters, boolean ignoreCase) {
        Method getter = null;
        Method setter = null;
        for (Method method : gettersOrSetters) {
            Class<?> parameterType;
            String methodName = method.getName();
            if (0 == method.getParameterCount()) {
                Class<?> returnType;
                if (StringKit.equals(methodName, CharsBacker.genGetter(fieldName), ignoreCase) && ((returnType = method.getReturnType()).isAssignableFrom(fieldType) || this.isMatchPrimitive && ClassKit.isBasicTypeMatch(returnType, fieldType))) {
                    getter = method;
                }
            } else if (StringKit.equals(methodName, CharsBacker.genSetter(fieldName), ignoreCase) && (fieldType.isAssignableFrom(parameterType = method.getParameterTypes()[0]) || this.isMatchPrimitive && ClassKit.isBasicTypeMatch(fieldType, parameterType))) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new Method[]{getter, setter};
    }
}

