/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.bean.path;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.miaixz.bus.core.bean.DynaBean;
import org.miaixz.bus.core.bean.path.BeanPath;
import org.miaixz.bus.core.bean.path.NodeBeanFactory;
import org.miaixz.bus.core.bean.path.node.EmptyNode;
import org.miaixz.bus.core.bean.path.node.ListNode;
import org.miaixz.bus.core.bean.path.node.NameNode;
import org.miaixz.bus.core.bean.path.node.Node;
import org.miaixz.bus.core.bean.path.node.RangeNode;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.BeanKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.FieldKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class DefaultNodeBeanFactory
implements NodeBeanFactory<Object> {
    public static final DefaultNodeBeanFactory INSTANCE = new DefaultNodeBeanFactory();

    private static Object getValueByListNode(Object bean, ListNode node) {
        String[] names = node.getUnWrappedNames();
        if (bean instanceof Collection) {
            return CollKit.getAny((Collection)bean, Convert.convert(int[].class, (Object)names));
        }
        if (ArrayKit.isArray(bean)) {
            return ArrayKit.getAny(bean, Convert.convert(int[].class, (Object)names));
        }
        Map<String, Object> map = bean instanceof Map ? (Map<String, Object>)bean : BeanKit.toBeanMap(bean);
        return MapKit.getAny(map, names);
    }

    private static Object getValueByNameNode(Object bean, NameNode node) {
        String name = node.getName();
        if ("$".equals(name)) {
            return bean;
        }
        Object value = DynaBean.of(bean).get(name);
        if (null == value && StringKit.lowerFirst(ClassKit.getClassName(bean, true)).equals(name)) {
            value = bean;
        }
        return value;
    }

    private static Object getValueByRangeNode(Object bean, RangeNode node) {
        if (bean instanceof Collection) {
            return CollKit.sub((Collection)bean, node.getStart(), node.getEnd(), node.getStep());
        }
        if (ArrayKit.isArray(bean)) {
            return ArrayKit.sub(bean, node.getStart(), node.getEnd(), node.getStep());
        }
        throw new UnsupportedOperationException("Can not get range value for: " + String.valueOf(bean.getClass()));
    }

    @Override
    public Object create(Object parent, BeanPath<Object> beanPath) {
        if (parent instanceof Map || parent instanceof List || ArrayKit.isArray(parent)) {
            Node node = ((BeanPath)beanPath.next()).getNode();
            if (node instanceof NameNode) {
                return ((NameNode)node).isNumber() ? new ArrayList() : new HashMap();
            }
            return new HashMap();
        }
        Node node = beanPath.getNode();
        if (node instanceof NameNode) {
            String name = ((NameNode)node).getName();
            Field field = FieldKit.getField(parent.getClass(), name);
            if (null == field) {
                throw new IllegalArgumentException("No field found for name: " + name);
            }
            return ReflectKit.newInstanceIfPossible(field.getType());
        }
        throw new UnsupportedOperationException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    @Override
    public Object getValue(Object bean, BeanPath<Object> beanPath) {
        Node node = beanPath.getNode();
        if (null == node || node instanceof EmptyNode) {
            return null;
        }
        if (node instanceof ListNode) {
            return DefaultNodeBeanFactory.getValueByListNode(bean, (ListNode)node);
        }
        if (node instanceof NameNode) {
            return DefaultNodeBeanFactory.getValueByNameNode(bean, (NameNode)node);
        }
        if (node instanceof RangeNode) {
            return DefaultNodeBeanFactory.getValueByRangeNode(bean, (RangeNode)node);
        }
        throw new UnsupportedOperationException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    @Override
    public Object setValue(Object bean, Object value, BeanPath<Object> beanPath) {
        Node node = beanPath.getNode();
        if (null == node || node instanceof EmptyNode) {
            return bean;
        }
        if (node instanceof NameNode) {
            return DynaBean.of(bean).set(((NameNode)node).getName(), value).getBean();
        }
        throw new UnsupportedOperationException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

