/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import java.util.Iterator;
import org.miaixz.bus.core.cache.provider.CacheObject;
import org.miaixz.bus.core.cache.provider.LockedCache;
import org.miaixz.bus.core.center.map.FixedLinkedHashMap;
import org.miaixz.bus.core.lang.mutable.Mutable;

public class LRUCache<K, V>
extends LockedCache<K, V> {
    private static final long serialVersionUID = 2852231786866L;

    public LRUCache(int capacity) {
        this(capacity, 0L);
    }

    public LRUCache(int capacity, long timeout) {
        if (Integer.MAX_VALUE == capacity) {
            --capacity;
        }
        this.capacity = capacity;
        this.timeout = timeout;
        FixedLinkedHashMap fixedLinkedHashMap = new FixedLinkedHashMap(capacity);
        fixedLinkedHashMap.setRemoveListener(entry -> {
            if (null != this.listener) {
                this.listener.onRemove(((Mutable)entry.getKey()).get(), ((CacheObject)entry.getValue()).getValue());
            }
        });
        this.cacheMap = fixedLinkedHashMap;
    }

    @Override
    protected int pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheObjIter();
        while (values.hasNext()) {
            CacheObject co = values.next();
            if (!co.isExpired()) continue;
            values.remove();
            this.onRemove(co.key, co.object);
            ++count;
        }
        return count;
    }
}

