/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.cache.provider;

import org.miaixz.bus.core.cache.CacheListener;
import org.miaixz.bus.core.cache.provider.CacheObject;
import org.miaixz.bus.core.cache.provider.TimedCache;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.lang.ref.Ref;

public class WeakCache<K, V>
extends TimedCache<K, V> {
    private static final long serialVersionUID = 2852232505330L;

    public WeakCache(long timeout) {
        super(timeout, new WeakConcurrentMap());
    }

    @Override
    public WeakCache<K, V> setListener(CacheListener<K, V> listener) {
        super.setListener((CacheListener)listener);
        WeakConcurrentMap map = (WeakConcurrentMap)this.cacheMap;
        map.setPurgeListener((key, value) -> listener.onRemove(Optional.ofNullable(key).map(Ref::get).map(Mutable::get).getOrNull(), Optional.ofNullable(value).map(Ref::get).map(CacheObject::getValue).getOrNull()));
        return this;
    }
}

