/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;
import org.miaixz.bus.core.xyz.SetKit;

public class CollectionOperation<E> {
    private final Collection<E>[] colls;

    public CollectionOperation(Collection<? extends E>[] colls) {
        this.colls = colls;
    }

    @SafeVarargs
    public static <E> CollectionOperation<E> of(Collection<? extends E> ... colls) {
        return new CollectionOperation<E>(colls);
    }

    private static <T> Collection<T> _union(Collection<T> coll1, Collection<T> coll2) {
        if (CollKit.isEmpty(coll1)) {
            return ListKit.of(coll2);
        }
        if (CollKit.isEmpty(coll2)) {
            return ListKit.of(coll1);
        }
        Map<T, Integer> map1 = CollKit.countMap(coll1);
        Map<T, Integer> map2 = CollKit.countMap(coll2);
        Set elements = CollectionOperation.of(map1.keySet(), map2.keySet()).unionDistinct();
        ArrayList list = new ArrayList(coll1.size() + coll2.size());
        for (Object t : elements) {
            int amount = Math.max(map1.getOrDefault(t, 0), map2.getOrDefault(t, 0));
            for (int i = 0; i < amount; ++i) {
                list.add(t);
            }
        }
        return list;
    }

    private static <E> Collection<E> _intersection(Collection<E> coll1, Collection<E> coll2) {
        if (CollKit.isEmpty(coll1) || CollKit.isEmpty(coll2)) {
            return ListKit.zero();
        }
        Map<E, Integer> map1 = CollKit.countMap(coll1);
        Map<E, Integer> map2 = CollKit.countMap(coll2);
        boolean isFirstSmaller = map1.size() <= map2.size();
        HashSet<E> elements = SetKit.of(isFirstSmaller ? map1.keySet() : map2.keySet());
        ArrayList list = new ArrayList(isFirstSmaller ? coll1.size() : coll2.size());
        for (Object t : elements) {
            int amount = Math.min(map1.getOrDefault(t, 0), map2.getOrDefault(t, 0));
            for (int i = 0; i < amount; ++i) {
                list.add(t);
            }
        }
        return list;
    }

    private static <T> Collection<T> _disjunction(Collection<T> coll1, Collection<T> coll2) {
        if (CollKit.isEmpty(coll1)) {
            if (CollKit.isEmpty(coll2)) {
                return ListKit.zero();
            }
            return coll2;
        }
        if (CollKit.isEmpty(coll2)) {
            return coll1;
        }
        ArrayList result = new ArrayList(coll1.size() + coll2.size());
        Map<T, Integer> map1 = CollKit.countMap(coll1);
        Map<T, Integer> map2 = CollKit.countMap(coll2);
        HashSet<T> elements = SetKit.of(map1.keySet());
        elements.addAll(map2.keySet());
        for (Object t : elements) {
            int amount = Math.abs(map1.getOrDefault(t, 0) - map2.getOrDefault(t, 0));
            for (int i = 0; i < amount; ++i) {
                result.add(t);
            }
        }
        return result;
    }

    public Collection<E> union() {
        Collection<E>[] colls = this.colls;
        if (ArrayKit.isEmpty(colls)) {
            return ListKit.zero();
        }
        Collection<E> result = colls[0];
        for (int i = 1; i < colls.length; ++i) {
            result = CollectionOperation._union(result, colls[i]);
        }
        return result;
    }

    public Set<E> unionDistinct() {
        Collection<E>[] colls = this.colls;
        int totalLength = 0;
        for (Collection<E> set : colls) {
            if (!CollKit.isNotEmpty(set)) continue;
            totalLength += set.size();
        }
        HashSet<E> result = new HashSet<E>(totalLength, 1.0f);
        for (Collection<E> set : colls) {
            if (!CollKit.isNotEmpty(set)) continue;
            result.addAll(set);
        }
        return result;
    }

    public List<E> unionAll() {
        Collection<E>[] colls = this.colls;
        if (ArrayKit.isEmpty(colls)) {
            return ListKit.zero();
        }
        int totalSize = 0;
        for (Collection<E> coll : colls) {
            if (!CollKit.isNotEmpty(coll)) continue;
            totalSize += CollKit.size(coll);
        }
        if (totalSize == 0) {
            return ListKit.zero();
        }
        ArrayList<E> result = new ArrayList<E>(totalSize);
        for (Collection<E> coll : colls) {
            if (!CollKit.isNotEmpty(coll)) continue;
            result.addAll(coll);
        }
        return result;
    }

    public Collection<E> intersection() {
        Collection<E>[] colls = this.colls;
        if (ArrayKit.isEmpty(colls)) {
            return ListKit.zero();
        }
        Collection<E> result = colls[0];
        for (int i = 1; i < colls.length; ++i) {
            result = CollectionOperation._intersection(result, colls[i]);
        }
        return result;
    }

    public Set<E> intersectionDistinct() {
        Collection<E>[] colls = this.colls;
        if (ArrayKit.isEmpty(colls)) {
            return SetKit.zeroLinked();
        }
        for (Collection<E> coll : colls) {
            if (!CollKit.isEmpty(coll)) continue;
            return SetKit.zeroLinked();
        }
        HashSet<E> result = SetKit.of(true, colls[0]);
        for (int i = 1; i < colls.length; ++i) {
            if (!CollKit.isNotEmpty(colls[i])) continue;
            result.retainAll(colls[i]);
        }
        return result;
    }

    public Collection<E> disjunction() {
        Collection<E>[] colls = this.colls;
        if (ArrayKit.isEmpty(colls)) {
            return ListKit.zero();
        }
        Collection<E> result = colls[0];
        for (int i = 1; i < colls.length; ++i) {
            result = CollectionOperation._disjunction(result, colls[i]);
        }
        return result;
    }

    public List<E> subtract() {
        Collection<E>[] colls = this.colls;
        if (ArrayKit.isEmpty(colls)) {
            return ListKit.zero();
        }
        ArrayList<E> result = ListKit.of(colls[0]);
        for (int i = 1; i < colls.length; ++i) {
            result.removeAll(colls[i]);
        }
        return result;
    }
}

