/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.miaixz.bus.core.center.array.ArrayValidator;
import org.miaixz.bus.core.xyz.IteratorKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class CollectionValidator {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IteratorKit.isEmpty(iterable);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return IteratorKit.isEmpty(iterator);
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || !enumeration.hasMoreElements();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return MapKit.isEmpty(map);
    }

    public static <T extends Collection<E>, E> T defaultIfEmpty(T collection, T defaultCollection) {
        return CollectionValidator.isEmpty(collection) ? defaultCollection : collection;
    }

    public static <T extends Collection<E>, E> T defaultIfEmpty(T collection, Function<T, T> handler, Supplier<? extends T> defaultSupplier) {
        return (T)(CollectionValidator.isEmpty(collection) ? (Collection)defaultSupplier.get() : (Collection)handler.apply(collection));
    }

    public static <T> Set<T> emptyIfNull(Set<T> set) {
        return ObjectKit.defaultIfNull(set, Collections.emptySet());
    }

    public static <T> List<T> emptyIfNull(List<T> list) {
        return ObjectKit.defaultIfNull(list, Collections.emptyList());
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionValidator.isEmpty(collection);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IteratorKit.isNotEmpty(iterable);
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return IteratorKit.isNotEmpty(iterator);
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        return IteratorKit.hasNull(IteratorKit.getIter(iterable));
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return MapKit.isNotEmpty(map);
    }

    public static boolean isSub(Collection<?> subCollection, Collection<?> collection) {
        if (CollectionValidator.size(subCollection) > CollectionValidator.size(collection)) {
            return false;
        }
        return IteratorKit.isSub(subCollection, collection);
    }

    public static boolean isEqualList(Collection<?> list1, Collection<?> list2) {
        return CollectionValidator.equals(list1, list2, false);
    }

    public static boolean equals(Collection<?> coll1, Collection<?> coll2, boolean ignoreOrder) {
        if (CollectionValidator.size(coll1) != CollectionValidator.size(coll2)) {
            return false;
        }
        return IteratorKit.equals(coll1, coll2, ignoreOrder);
    }

    public static int size(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof Iterable) {
            return IteratorKit.size((Iterable)object);
        }
        if (object instanceof Iterator) {
            return IteratorKit.size((Iterator)object);
        }
        if (object instanceof Enumeration) {
            int total = 0;
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                ++total;
                it.nextElement();
            }
            return total;
        }
        if (ArrayValidator.isArray(object)) {
            return ArrayValidator.length(object);
        }
        throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
    }
}

