/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture;

import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;

public class Vesta
extends Loops {
    public static final String[] NUMBERS = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    protected SixtyCycle firstDaySixtyCycle;

    public Vesta(int lunarYear) {
        this.firstDaySixtyCycle = LunarDay.fromYmd(lunarYear, 1, 1).getSixtyCycle();
    }

    public static Vesta fromLunarYear(int lunarYear) {
        return new Vesta(lunarYear);
    }

    protected String byHeavenStem(int n) {
        return NUMBERS[this.firstDaySixtyCycle.getHeavenStem().stepsTo(n)];
    }

    protected String byEarthBranch(int n) {
        return NUMBERS[this.firstDaySixtyCycle.getEarthBranch().stepsTo(n)];
    }

    public String getMouse() {
        return String.format("%s\u9f20\u5077\u7cae", this.byEarthBranch(0));
    }

    public String getGrass() {
        return String.format("\u8349\u5b50%s\u5206", this.byEarthBranch(0));
    }

    public String getCattle() {
        return String.format("%s\u725b\u8015\u7530", this.byEarthBranch(1));
    }

    public String getFlower() {
        return String.format("\u82b1\u6536%s\u5206", this.byEarthBranch(3));
    }

    public String getDragon() {
        return String.format("%s\u9f99\u6cbb\u6c34", this.byEarthBranch(4));
    }

    public String getHorse() {
        return String.format("%s\u9a6c\u9a6e\u8c37", this.byEarthBranch(6));
    }

    public String getChicken() {
        return String.format("%s\u9e21\u62a2\u7c73", this.byEarthBranch(9));
    }

    public String getSilkworm() {
        return String.format("%s\u59d1\u770b\u8695", this.byEarthBranch(9));
    }

    public String getPig() {
        return String.format("%s\u5c60\u5171\u732a", this.byEarthBranch(11));
    }

    public String getField() {
        return String.format("\u7532\u7530%s\u5206", this.byHeavenStem(0));
    }

    public String getCake() {
        return String.format("%s\u4eba\u5206\u997c", this.byHeavenStem(2));
    }

    public String getGold() {
        return String.format("%s\u65e5\u5f97\u91d1", this.byHeavenStem(7));
    }

    public String getPeopleCakes() {
        return String.format("%s\u4eba%s\u4e19", this.byEarthBranch(2), this.byHeavenStem(2));
    }

    public String getPeopleHoes() {
        return String.format("%s\u4eba%s\u9504", this.byEarthBranch(2), this.byHeavenStem(3));
    }

    @Override
    public String getName() {
        return "\u7076\u9a6c\u5934";
    }
}

