/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.fetus;

import org.miaixz.bus.core.center.date.culture.Tradition;
import org.miaixz.bus.core.center.date.culture.cn.Direction;
import org.miaixz.bus.core.center.date.culture.cn.fetus.FetusEarthBranch;
import org.miaixz.bus.core.center.date.culture.cn.fetus.FetusHeavenStem;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;

public class FetusDay
extends Tradition {
    protected FetusHeavenStem fetusHeavenStem;
    protected FetusEarthBranch fetusEarthBranch;
    protected int side;
    protected Direction direction;

    protected FetusDay(SixtyCycle sixtyCycle) {
        this.fetusHeavenStem = new FetusHeavenStem(sixtyCycle.getHeavenStem().getIndex() % 5);
        this.fetusEarthBranch = new FetusEarthBranch(sixtyCycle.getEarthBranch().getIndex() % 6);
        int index = (new int[]{3, 3, 8, 8, 8, 8, 8, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, -9, -9, -9, -9, -9, -5, -5, -1, -1, -1, -3, -7, -7, -7, -7, -5, 7, 7, 7, 7, 7, 7, 2, 2, 2, 2, 2, 3, 3, 3, 3})[sixtyCycle.getIndex()];
        this.side = index < 0 ? 0 : 1;
        this.direction = Direction.fromIndex(index);
    }

    public FetusDay(LunarDay lunarDay) {
        this(lunarDay.getSixtyCycle());
    }

    public FetusDay(SixtyCycleDay sixtyCycleDay) {
        this(sixtyCycleDay.getSixtyCycle());
    }

    public static FetusDay fromLunarDay(LunarDay lunarDay) {
        return new FetusDay(lunarDay);
    }

    public static FetusDay fromSixtyCycleDay(SixtyCycleDay sixtyCycleDay) {
        return new FetusDay(sixtyCycleDay);
    }

    @Override
    public String getName() {
        Object s = this.fetusHeavenStem.getName() + this.fetusEarthBranch.getName();
        if ("\u95e8\u95e8".equals(s)) {
            s = "\u5360\u5927\u95e8";
        } else if ("\u7893\u78e8\u7893".equals(s)) {
            s = "\u5360\u7893\u78e8";
        } else if ("\u623f\u5e8a\u5e8a".equals(s)) {
            s = "\u5360\u623f\u5e8a";
        } else if (((String)s).startsWith("\u95e8")) {
            s = "\u5360" + (String)s;
        }
        s = (String)s + " ";
        String directionName = this.direction.getName();
        if (0 == this.side) {
            s = (String)s + "\u623f";
        }
        s = (String)s + "\u5185";
        if (1 == this.side && "\u5317\u5357\u897f\u4e1c".contains(directionName)) {
            s = (String)s + "\u6b63";
        }
        s = (String)s + directionName;
        return s;
    }

    public int getSide() {
        return this.side;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public FetusHeavenStem getFetusHeavenStem() {
        return this.fetusHeavenStem;
    }

    public FetusEarthBranch getFetusEarthBranch() {
        return this.fetusEarthBranch;
    }
}

