/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.center.date.culture.cn.sixty;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.center.date.culture.Loops;
import org.miaixz.bus.core.center.date.culture.cn.Direction;
import org.miaixz.bus.core.center.date.culture.cn.Duty;
import org.miaixz.bus.core.center.date.culture.cn.Element;
import org.miaixz.bus.core.center.date.culture.cn.God;
import org.miaixz.bus.core.center.date.culture.cn.Taboo;
import org.miaixz.bus.core.center.date.culture.cn.fetus.FetusDay;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycle;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleHour;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleMonth;
import org.miaixz.bus.core.center.date.culture.cn.sixty.SixtyCycleYear;
import org.miaixz.bus.core.center.date.culture.cn.star.nine.NineStar;
import org.miaixz.bus.core.center.date.culture.cn.star.twelve.TwelveStar;
import org.miaixz.bus.core.center.date.culture.cn.star.twentyeight.TwentyEightStar;
import org.miaixz.bus.core.center.date.culture.lunar.LunarDay;
import org.miaixz.bus.core.center.date.culture.lunar.LunarMonth;
import org.miaixz.bus.core.center.date.culture.lunar.LunarYear;
import org.miaixz.bus.core.center.date.culture.solar.SolarDay;
import org.miaixz.bus.core.center.date.culture.solar.SolarTerms;
import org.miaixz.bus.core.center.date.culture.solar.SolarTime;

public class SixtyCycleDay
extends Loops {
    protected SolarDay solarDay;
    protected SixtyCycleMonth month;
    protected SixtyCycle day;

    SixtyCycleDay(SolarDay solarDay, SixtyCycleMonth month, SixtyCycle day) {
        this.solarDay = solarDay;
        this.month = month;
        this.day = day;
    }

    public SixtyCycleDay(SolarDay solarDay) {
        SolarTerms term;
        int index;
        int solarYear = solarDay.getYear();
        SolarDay springSolarDay = SolarTerms.fromIndex(solarYear, 3).getJulianDay().getSolarDay();
        LunarDay lunarDay = solarDay.getLunarDay();
        LunarYear lunarYear = lunarDay.getLunarMonth().getLunarYear();
        if (lunarYear.getYear() == solarYear) {
            if (solarDay.isBefore(springSolarDay)) {
                lunarYear = lunarYear.next(-1);
            }
        } else if (lunarYear.getYear() < solarYear && !solarDay.isBefore(springSolarDay)) {
            lunarYear = lunarYear.next(1);
        }
        if ((index = (term = solarDay.getTerm()).getIndex() - 3) < 0 && term.getJulianDay().getSolarDay().isAfter(springSolarDay)) {
            index += 24;
        }
        this.solarDay = solarDay;
        this.month = new SixtyCycleMonth(SixtyCycleYear.fromYear(lunarYear.getYear()), LunarMonth.fromYm(solarYear, 1).getSixtyCycle().next((int)Math.floor((double)index * 1.0 / 2.0)));
        this.day = lunarDay.getSixtyCycle();
    }

    public static SixtyCycleDay fromSolarDay(SolarDay solarDay) {
        return new SixtyCycleDay(solarDay);
    }

    public SolarDay getSolarDay() {
        return this.solarDay;
    }

    public SixtyCycleMonth getSixtyCycleMonth() {
        return this.month;
    }

    public SixtyCycle getYear() {
        return this.month.getYear();
    }

    public SixtyCycle getMonth() {
        return this.month.getSixtyCycle();
    }

    public SixtyCycle getSixtyCycle() {
        return this.day;
    }

    @Override
    public String getName() {
        return String.format("%s\u65e5", this.day);
    }

    @Override
    public String toString() {
        return String.format("%s%s", this.month, this.getName());
    }

    public Duty getDuty() {
        return Duty.fromIndex(this.day.getEarthBranch().getIndex() - this.getMonth().getEarthBranch().getIndex());
    }

    public TwelveStar getTwelveStar() {
        return TwelveStar.fromIndex(this.day.getEarthBranch().getIndex() + (8 - this.getMonth().getEarthBranch().getIndex() % 6) * 2);
    }

    public NineStar getNineStar() {
        SolarTerms dongZhi = SolarTerms.fromIndex(this.solarDay.getYear(), 0);
        SolarTerms xiaZhi = dongZhi.next(12);
        SolarTerms dongZhi2 = dongZhi.next(24);
        SolarDay dongZhiSolar = dongZhi.getJulianDay().getSolarDay();
        SolarDay xiaZhiSolar = xiaZhi.getJulianDay().getSolarDay();
        SolarDay dongZhiSolar2 = dongZhi2.getJulianDay().getSolarDay();
        int dongZhiIndex = dongZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int xiaZhiIndex = xiaZhiSolar.getLunarDay().getSixtyCycle().getIndex();
        int dongZhiIndex2 = dongZhiSolar2.getLunarDay().getSixtyCycle().getIndex();
        SolarDay solarShunBai = dongZhiSolar.next(dongZhiIndex > 29 ? 60 - dongZhiIndex : -dongZhiIndex);
        SolarDay solarShunBai2 = dongZhiSolar2.next(dongZhiIndex2 > 29 ? 60 - dongZhiIndex2 : -dongZhiIndex2);
        SolarDay solarNiZi = xiaZhiSolar.next(xiaZhiIndex > 29 ? 60 - xiaZhiIndex : -xiaZhiIndex);
        int offset = 0;
        if (!this.solarDay.isBefore(solarShunBai) && this.solarDay.isBefore(solarNiZi)) {
            offset = this.solarDay.subtract(solarShunBai);
        } else if (!this.solarDay.isBefore(solarNiZi) && this.solarDay.isBefore(solarShunBai2)) {
            offset = 8 - this.solarDay.subtract(solarNiZi);
        } else if (!this.solarDay.isBefore(solarShunBai2)) {
            offset = this.solarDay.subtract(solarShunBai2);
        } else if (this.solarDay.isBefore(solarShunBai)) {
            offset = 8 + solarShunBai.subtract(this.solarDay);
        }
        return NineStar.fromIndex(offset);
    }

    public Direction getJupiterDirection() {
        int index = this.day.getIndex();
        return index % 12 < 6 ? Element.fromIndex(index / 12).getDirection() : this.month.getSixtyCycleYear().getJupiterDirection();
    }

    public FetusDay getFetusDay() {
        return FetusDay.fromSixtyCycleDay(this);
    }

    public TwentyEightStar getTwentyEightStar() {
        return TwentyEightStar.fromIndex((new int[]{10, 18, 26, 6, 14, 22, 2})[this.solarDay.getWeek().getIndex()]).next(-7 * this.day.getEarthBranch().getIndex());
    }

    public List<God> getGods() {
        return God.getDayGods(this.getMonth(), this.day);
    }

    public List<Taboo> getRecommends() {
        return Taboo.getDayRecommends(this.getMonth(), this.day);
    }

    public List<Taboo> getAvoids() {
        return Taboo.getDayAvoids(this.getMonth(), this.day);
    }

    @Override
    public SixtyCycleDay next(int n) {
        return SixtyCycleDay.fromSolarDay(this.solarDay.next(n));
    }

    public List<SixtyCycleHour> getHours() {
        ArrayList<SixtyCycleHour> l = new ArrayList<SixtyCycleHour>();
        SolarDay d = this.solarDay.next(-1);
        SixtyCycleHour h = SixtyCycleHour.fromSolarTime(SolarTime.fromYmdHms(d.getYear(), d.getMonth(), d.getDay(), 23, 0, 0));
        l.add(h);
        for (int i = 0; i < 11; ++i) {
            h = h.next(7200);
            l.add(h);
        }
        return l;
    }
}

